/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.auth.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.auth.ShibbolethAuthAuthority;
import org.jitsi.jicofo.auth.rest.BadRequestExceptionWithMessage;
import org.jitsi.jicofo.auth.rest.InternalServerErrorWithMessage;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

@Path(value="/login")
public class ShibbolethLogin {
    @NotNull
    private final ShibbolethAuthAuthority shibbolethAuthAuthority;

    private static String getShibAttr(HttpServletRequest request, String name) {
        String value = (String)request.getAttribute(name);
        if (value == null) {
            value = request.getHeader(name);
        }
        return value;
    }

    public ShibbolethLogin(@NotNull ShibbolethAuthAuthority shibbolethAuthAuthority) {
        this.shibbolethAuthAuthority = shibbolethAuthAuthority;
    }

    @GET
    public String login(@QueryParam(value="room") String room, @QueryParam(value="machineUID") String machineUid, @QueryParam(value="close") String closeParam, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        EntityBareJid roomJid;
        if (room == null) {
            throw new BadRequestExceptionWithMessage("Missing mandatory parameter 'room'");
        }
        if (machineUid == null) {
            throw new BadRequestExceptionWithMessage("Missing mandatory parameter 'machineUID'");
        }
        String email = ShibbolethLogin.getShibAttr(request, "mail");
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new InternalServerErrorWithMessage("Attribute 'mail' not provided - check server configuration");
        }
        try {
            roomJid = JidCreate.entityBareFrom((String)room);
        }
        catch (XmppStringprepException e) {
            throw new BadRequestExceptionWithMessage("Room name is not a valid JID");
        }
        String sessionId = this.shibbolethAuthAuthority.authenticateUser(machineUid, email, roomJid);
        if (sessionId == null) {
            throw new InternalServerErrorWithMessage("Authentication failed");
        }
        String displayName = ShibbolethLogin.getShibAttr(request, "displayName");
        if (displayName == null) {
            displayName = email;
        }
        boolean close = "true".equalsIgnoreCase(closeParam);
        return this.createResponse(displayName, close, sessionId, roomJid);
    }

    private String createResponse(String displayName, boolean close, String sessionId, EntityBareJid roomJid) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><head/><body>\n");
        sb.append("<h1>Hello!<h1/>\n");
        if (!close) {
            sb.append("<h2>You should be redirected back to the conference soon...<h2/>\n");
        }
        String script = "<script>\n(function() {\n var sessionId = '" + sessionId + "';\n localStorage.setItem('sessionId', sessionId);\n console.info('sessionID :' + sessionId);\n var displayName = '" + displayName + "';\n console.info('displayName :' + displayName);\n var settings = localStorage.getItem('features/base/settings');\n console.info('settings :' + settings);\n if (settings){\n     try {\n            var settingsObj = JSON.parse(settings);\n            if ( settingsObj && !settingsObj.displayName ) {\n                settingsObj.displayName = displayName;\n                localStorage.setItem('features/base/settings', JSON.stringify(settingsObj));\n         }\n     }\n   catch(e){\n     console.error('Unable to parse settings JSON');\n   }\n }\n";
        script = close ? script + "var opener = window.opener;\nif (opener) {\n   var res = opener.postMessage(      { sessionId: sessionId },\n      window.opener.location.href);\n   console.info('res: ', res);\n   window.close();\n} else {\n   console.error('No opener !');\n}\n" : script + " window.location.href='../" + String.valueOf(roomJid.getLocalpart()) + "';\n";
        sb.append(script).append("})();\n</script>\n");
        sb.append("</body></html>\n");
        return sb.toString();
    }
}

