/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.swing.BorderIcon;
import free.util.swing.LocalizationService;
import free.util.swing.Mnemonicable;
import free.util.swing.SolidColorRectangleIcon;
import free.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooser
extends JComponent
implements Mnemonicable {
    private final JButton button;
    private final JLabel label;
    private static final Dimension ICON_SIZE = new Dimension(25, 10);
    private static final Color ICON_BORDER_COLOR = Color.GRAY;
    private Color color;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    static /* synthetic */ Class class$free$util$swing$ColorChooser;

    public ColorChooser() {
        this(null, Color.black);
    }

    public ColorChooser(String string) {
        this(string, Color.black);
    }

    public ColorChooser(Color color) {
        this(null, color);
    }

    public ColorChooser(String string, Color color) {
        this.label = new JLabel();
        this.button = new JButton();
        this.setText(string);
        this.setColor(color);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.label);
        this.add(Box.createHorizontalStrut(20));
        this.add(Box.createHorizontalGlue());
        this.add(this.button);
        this.label.setLabelFor(this.button);
        this.button.setDefaultCapable(false);
        if (SwingUtils.isMacLnF()) {
            this.button.setMargin(new Insets(5, 5, 5, 5));
        } else {
            this.button.setMargin(new Insets(3, 3, 3, 3));
        }
        this.color = color;
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SwingUtilities.windowForComponent(ColorChooser.this), LocalizationService.getForClass(class$free$util$swing$ColorChooser == null ? (class$free$util$swing$ColorChooser = ColorChooser.class$("free.util.swing.ColorChooser")) : class$free$util$swing$ColorChooser).getString("dialogTitle"), ColorChooser.this.color);
                if (color != null) {
                    ColorChooser.this.setColor(color);
                }
            }
        });
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setDisplayedMnemonicIndex(int n) {
        this.label.setDisplayedMnemonicIndex(n);
    }

    public void setEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.button.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? ColorChooser.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        SolidColorRectangleIcon solidColorRectangleIcon = new SolidColorRectangleIcon(ICON_SIZE, color);
        this.button.setIcon(new BorderIcon(solidColorRectangleIcon, ICON_BORDER_COLOR));
        this.fireStateChanged();
    }
}

