/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.tools;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSourceTask
extends SourceTask {
    private static final Logger log = LoggerFactory.getLogger(MockSourceTask.class);
    private String mockMode;
    private long startTimeMs;
    private long failureDelayMs;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> config) {
        this.mockMode = config.get("mock_mode");
        if ("task-failure".equals(this.mockMode)) {
            this.startTimeMs = System.currentTimeMillis();
            String delayMsString = config.get("delay_ms");
            this.failureDelayMs = 15000L;
            if (delayMsString != null) {
                this.failureDelayMs = Long.parseLong(delayMsString);
            }
            log.debug("Started MockSourceTask at {} with failure scheduled in {} ms", (Object)this.startTimeMs, (Object)this.failureDelayMs);
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        long now;
        if ("task-failure".equals(this.mockMode) && (now = System.currentTimeMillis()) > this.startTimeMs + this.failureDelayMs) {
            log.debug("Triggering source task failure");
            throw new RuntimeException();
        }
        return Collections.emptyList();
    }

    public void stop() {
    }
}

