/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n37#2:35\n1863#3,2:36\n*S KotlinDebug\n*F\n+ 1 FirAnyDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyDeprecationChecker\n*L\n22#1:35\n25#1:36,2\n*E\n"})
public final class FirAnyDeprecationChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAnyDeprecationChecker INSTANCE = new FirAnyDeprecationChecker();

    private FirAnyDeprecationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride() || !FirDeclarationUtilKt.isMethodOfAny(declaration.getSymbol())) {
            return;
        }
        Map<ClassId, Boolean> deprecationAnnotations = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(context.getSession()).getDeprecationAnnotationsWithOverridesPropagation();
        Iterable $this$forEach$iv = declaration.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isOptInMarker;
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl = false;
            boolean isDeprecationMarker = deprecationAnnotations.containsKey(FirAnnotationUtilsKt.toAnnotationClassId(annotation, context.getSession()));
            boolean bl2 = isOptInMarker = FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context.getSession()) != null;
            if (!isDeprecationMarker && !isOptInMarker) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getPOTENTIALLY_NON_REPORTED_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

