require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_UFS_INODE_H_)) {
    eval 'sub _UFS_UFS_INODE_H_ () {1;}' unless defined(&_UFS_UFS_INODE_H_);
    require 'sys/vnode.ph';
    require 'ufs/ufs/dinode.ph';
    require 'ufs/ufs/dir.ph';
    require 'ufs/ufs/quota.ph';
    require 'ufs/ext2fs/ext2fs_dinode.ph';
    require 'ufs/ext2fs/ext2fs_extents.ph';
    require 'miscfs/genfs/genfs_node.ph';
    eval 'sub UFS_CHECK_CRAPCOUNTER {
        my($dp) = @_;
	    eval q((( &void)($dp)-> &i_crapcounter));
    }' unless defined(&UFS_CHECK_CRAPCOUNTER);
    eval 'sub i_fs () { ($inode_u->{fs});}' unless defined(&i_fs);
    eval 'sub i_lfs () { ($inode_u->{lfs});}' unless defined(&i_lfs);
    eval 'sub i_e2fs () { ($inode_u->{e2fs});}' unless defined(&i_e2fs);
    eval 'sub i_snapblklist () { ($inode_ext->{ffs}->{ffs_snapblklist});}' unless defined(&i_snapblklist);
    eval 'sub i_ffs_first_data_blk () { ($inode_ext->{ffs}->{ffs_first_data_blk});}' unless defined(&i_ffs_first_data_blk);
    eval 'sub i_ffs_first_indir_blk () { ($inode_ext->{ffs}->{ffs_first_indir_blk});}' unless defined(&i_ffs_first_indir_blk);
    eval 'sub i_e2fs_last_lblk () { ($inode_ext->{e2fs}->{ext2fs_last_lblk});}' unless defined(&i_e2fs_last_lblk);
    eval 'sub i_e2fs_last_blk () { ($inode_ext->{e2fs}->{ext2fs_last_blk});}' unless defined(&i_e2fs_last_blk);
    eval 'sub i_ffs1_atime () { ($i_din->{ffs1_din}->{di_atime});}' unless defined(&i_ffs1_atime);
    eval 'sub i_ffs1_atimensec () { ($i_din->{ffs1_din}->{di_atimensec});}' unless defined(&i_ffs1_atimensec);
    eval 'sub i_ffs1_blocks () { ($i_din->{ffs1_din}->{di_blocks});}' unless defined(&i_ffs1_blocks);
    eval 'sub i_ffs1_ctime () { ($i_din->{ffs1_din}->{di_ctime});}' unless defined(&i_ffs1_ctime);
    eval 'sub i_ffs1_ctimensec () { ($i_din->{ffs1_din}->{di_ctimensec});}' unless defined(&i_ffs1_ctimensec);
    eval 'sub i_ffs1_db () { ($i_din->{ffs1_din}->{di_db});}' unless defined(&i_ffs1_db);
    eval 'sub i_ffs1_flags () { ($i_din->{ffs1_din}->{di_flags});}' unless defined(&i_ffs1_flags);
    eval 'sub i_ffs1_gen () { ($i_din->{ffs1_din}->{di_gen});}' unless defined(&i_ffs1_gen);
    eval 'sub i_ffs1_gid () { ($i_din->{ffs1_din}->{di_gid});}' unless defined(&i_ffs1_gid);
    eval 'sub i_ffs1_ib () { ($i_din->{ffs1_din}->{di_ib});}' unless defined(&i_ffs1_ib);
    eval 'sub i_ffs1_mode () { ($i_din->{ffs1_din}->{di_mode});}' unless defined(&i_ffs1_mode);
    eval 'sub i_ffs1_mtime () { ($i_din->{ffs1_din}->{di_mtime});}' unless defined(&i_ffs1_mtime);
    eval 'sub i_ffs1_mtimensec () { ($i_din->{ffs1_din}->{di_mtimensec});}' unless defined(&i_ffs1_mtimensec);
    eval 'sub i_ffs1_nlink () { ($i_din->{ffs1_din}->{di_nlink});}' unless defined(&i_ffs1_nlink);
    eval 'sub i_ffs1_rdev () { ($i_din->{ffs1_din}->{di_rdev});}' unless defined(&i_ffs1_rdev);
    eval 'sub i_ffs1_size () { ($i_din->{ffs1_din}->{di_size});}' unless defined(&i_ffs1_size);
    eval 'sub i_ffs1_uid () { ($i_din->{ffs1_din}->{di_uid});}' unless defined(&i_ffs1_uid);
    eval 'sub i_ffs1_ouid () { ($i_din->{ffs1_din}->{di_oldids[0]});}' unless defined(&i_ffs1_ouid);
    eval 'sub i_ffs1_ogid () { ($i_din->{ffs1_din}->{di_oldids[1]});}' unless defined(&i_ffs1_ogid);
    eval 'sub i_ffs2_atime () { ($i_din->{ffs2_din}->{di_atime});}' unless defined(&i_ffs2_atime);
    eval 'sub i_ffs2_atimensec () { ($i_din->{ffs2_din}->{di_atimensec});}' unless defined(&i_ffs2_atimensec);
    eval 'sub i_ffs2_birthtime () { ($i_din->{ffs2_din}->{di_birthtime});}' unless defined(&i_ffs2_birthtime);
    eval 'sub i_ffs2_birthnsec () { ($i_din->{ffs2_din}->{di_birthnsec});}' unless defined(&i_ffs2_birthnsec);
    eval 'sub i_ffs2_blocks () { ($i_din->{ffs2_din}->{di_blocks});}' unless defined(&i_ffs2_blocks);
    eval 'sub i_ffs2_blksize () { ($i_din->{ffs2_din}->{di_blksize});}' unless defined(&i_ffs2_blksize);
    eval 'sub i_ffs2_ctime () { ($i_din->{ffs2_din}->{di_ctime});}' unless defined(&i_ffs2_ctime);
    eval 'sub i_ffs2_ctimensec () { ($i_din->{ffs2_din}->{di_ctimensec});}' unless defined(&i_ffs2_ctimensec);
    eval 'sub i_ffs2_db () { ($i_din->{ffs2_din}->{di_db});}' unless defined(&i_ffs2_db);
    eval 'sub i_ffs2_flags () { ($i_din->{ffs2_din}->{di_flags});}' unless defined(&i_ffs2_flags);
    eval 'sub i_ffs2_gen () { ($i_din->{ffs2_din}->{di_gen});}' unless defined(&i_ffs2_gen);
    eval 'sub i_ffs2_gid () { ($i_din->{ffs2_din}->{di_gid});}' unless defined(&i_ffs2_gid);
    eval 'sub i_ffs2_ib () { ($i_din->{ffs2_din}->{di_ib});}' unless defined(&i_ffs2_ib);
    eval 'sub i_ffs2_mode () { ($i_din->{ffs2_din}->{di_mode});}' unless defined(&i_ffs2_mode);
    eval 'sub i_ffs2_mtime () { ($i_din->{ffs2_din}->{di_mtime});}' unless defined(&i_ffs2_mtime);
    eval 'sub i_ffs2_mtimensec () { ($i_din->{ffs2_din}->{di_mtimensec});}' unless defined(&i_ffs2_mtimensec);
    eval 'sub i_ffs2_nlink () { ($i_din->{ffs2_din}->{di_nlink});}' unless defined(&i_ffs2_nlink);
    eval 'sub i_ffs2_rdev () { ($i_din->{ffs2_din}->{di_rdev});}' unless defined(&i_ffs2_rdev);
    eval 'sub i_ffs2_size () { ($i_din->{ffs2_din}->{di_size});}' unless defined(&i_ffs2_size);
    eval 'sub i_ffs2_uid () { ($i_din->{ffs2_din}->{di_uid});}' unless defined(&i_ffs2_uid);
    eval 'sub i_ffs2_kernflags () { ($i_din->{ffs2_din}->{di_kernflags});}' unless defined(&i_ffs2_kernflags);
    eval 'sub i_ffs2_extsize () { ($i_din->{ffs2_din}->{di_extsize});}' unless defined(&i_ffs2_extsize);
    eval 'sub i_ffs2_extb () { ($i_din->{ffs2_din}->{di_extb});}' unless defined(&i_ffs2_extb);
    eval 'sub IN_ACCESS () {0x1;}' unless defined(&IN_ACCESS);
    eval 'sub IN_CHANGE () {0x2;}' unless defined(&IN_CHANGE);
    eval 'sub IN_UPDATE () {0x4;}' unless defined(&IN_UPDATE);
    eval 'sub IN_MODIFIED () {0x8;}' unless defined(&IN_MODIFIED);
    eval 'sub IN_ACCESSED () {0x10;}' unless defined(&IN_ACCESSED);
    eval 'sub IN_SHLOCK () {0x40;}' unless defined(&IN_SHLOCK);
    eval 'sub IN_EXLOCK () {0x80;}' unless defined(&IN_EXLOCK);
    eval 'sub IN_SPACECOUNTED () {0x400;}' unless defined(&IN_SPACECOUNTED);
    eval 'sub IN_MODIFY () {0x2000;}' unless defined(&IN_MODIFY);
    if(defined(&_KERNEL)) {
	eval 'sub HAS_ACLS {
	    my($ip) = @_;
    	    eval q((($ip)-> ($i_ump->{um_fstype}) ==  &UFS2  && ($ip)-> &i_ffs2_extsize > 0));
	}' unless defined(&HAS_ACLS);
	eval 'sub DIP {
	    my($ip, $field) = @_;
    	    eval q(((($ip)-> ($i_ump->{um_fstype}) ==  &UFS1) ? ($ip)-> &i_ffs1_$field : ($ip)-> &i_ffs2_$field));
	}' unless defined(&DIP);
	eval 'sub DIP_ASSIGN {
	    my($ip, $field, $value) = @_;
    	    eval q( &do {  &if (($ip)-> ($i_ump->{um_fstype}) ==  &UFS1) ($ip)-> &i_ffs1_$field = ($value);  &else ($ip)-> &i_ffs2_$field = ($value); }  &while(0));
	}' unless defined(&DIP_ASSIGN);
	eval 'sub DIP_ADD {
	    my($ip, $field, $value) = @_;
    	    eval q( &do {  &if (($ip)-> ($i_ump->{um_fstype}) ==  &UFS1) ($ip)-> &i_ffs1_$field += ($value);  &else ($ip)-> &i_ffs2_$field += ($value); }  &while(0));
	}' unless defined(&DIP_ADD);
	eval 'sub SHORTLINK {
	    my($ip) = @_;
    	    eval q(((($ip)-> ($i_ump->{um_fstype}) ==  &UFS1) ? ( &void *)($ip)-> &i_ffs1_db : ( &void *)($ip)-> &i_ffs2_db));
	}' unless defined(&SHORTLINK);
	eval 'sub VTOI {
	    my($vp) = @_;
    	    eval q((($vp)-> &v_data));
	}' unless defined(&VTOI);
	eval 'sub ITOV {
	    my($ip) = @_;
    	    eval q((($ip)-> &i_vnode));
	}' unless defined(&ITOV);
    }
}
1;
