/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentRevisionTrackerBase
implements DeploymentRevisionTracker {
    public static final long MAX_FILE_SIZE = Long.getLong("com.jetbrains.plugins.webDeployment.base_revision_max_size", 0x100000L);
    private static final Logger LOG = Logger.getInstance(DeploymentRevisionTracker.class);
    @Nullable
    private final Project myProject;
    private final File myMapFile;
    private final ReplacePathToMacroMap myMacros = new ReplacePathToMacroMap();
    private PersistentHashMap<String, Map<String, DeploymentRevisionTracker.Revision>> myMap;

    public DeploymentRevisionTrackerBase(@Nullable Project project, String projectName, String projectPath) {
        this.myProject = project;
        this.myMacros.addMacroReplacement(projectPath, "PROJECT_DIR");
        this.myMapFile = DeploymentRevisionTrackerBase.getMapFile(projectName, projectPath);
    }

    private static File getMapFile(String projectName, String projectRoot) {
        File dir = new File(PathManager.getSystemPath(), "deployment");
        return new File(dir, projectName + "." + Integer.toHexString(FileUtil.toSystemDependentName((String)projectRoot).hashCode()));
    }

    @Nullable
    private PersistentHashMap<String, Map<String, DeploymentRevisionTracker.Revision>> getMap(boolean createIfMissing) {
        if (this.myMap == null) {
            if (!this.myMapFile.exists()) {
                if (createIfMissing) {
                    this.myMapFile.getParentFile().mkdirs();
                } else {
                    return null;
                }
            }
            try {
                this.openMapFromFile();
            }
            catch (IOException e) {
                return this.recreateMap(e);
            }
        }
        return this.myMap;
    }

    private PersistentHashMap<String, Map<String, DeploymentRevisionTracker.Revision>> recreateMap(IOException e) {
        LOG.warn("Storage corrupted, recreating", (Throwable)e);
        if (this.myMap != null) {
            try {
                this.myMap.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.clearFiles();
        try {
            this.openMapFromFile();
            ApplicationManager.getApplication().invokeLater(() -> {
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(WDBundle.message("revisions.cache.corrupted.balloon.message", new Object[0]), MessageType.WARNING, null).setShowCallout(false).createBalloon();
                IdeFrame frame = WindowManagerEx.getInstanceEx().findFrameFor(this.myProject);
                Rectangle rect = frame.getComponent().getBounds();
                Point p = new Point(rect.x + rect.width - 50, rect.y + 30);
                RelativePoint point = new RelativePoint((Component)frame.getComponent(), p);
                balloon.show(point, Balloon.Position.below);
                Disposer.register((Disposable)(this.myProject != null ? this.myProject : ApplicationManager.getApplication()), (Disposable)balloon);
            }, o -> this.myProject == null || this.myProject.isDefault() ? false : !this.myProject.isOpen() || this.myProject.isDisposed());
        }
        catch (IOException ex) {
            LOG.error("Failed to recreate storage", (Throwable)e);
        }
        return this.myMap;
    }

    protected void clearFiles() {
        PersistentHashMap.deleteFilesStartingWith((File)this.myMapFile);
    }

    private void openMapFromFile() throws IOException {
        this.myMap = new PersistentHashMap(this.myMapFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new MyValueExternaliser());
        Set existingIds = GroupedServersConfigManager.getInstance(this.myProject).getFlattenedServers().stream().filter(server -> server.needsTransfer()).map(server -> DeploymentRevisionTrackerBase.getEntryKey(server)).collect(Collectors.toSet());
        Collection keys = this.myMap.getAllKeysWithExistingMapping();
        for (String key : keys) {
            Map entry = (Map)this.myMap.get((Object)key);
            boolean changed = entry.keySet().retainAll(existingIds);
            if (!changed) continue;
            if (entry.isEmpty()) {
                this.myMap.remove((Object)key);
                continue;
            }
            this.myMap.put((Object)key, (Object)entry);
        }
    }

    @Override
    @Nullable
    public synchronized DeploymentRevisionTracker.Revision getBaseRevision(String filePath, Deployable server) {
        PersistentHashMap<String, Map<String, DeploymentRevisionTracker.Revision>> map = this.getMap(false);
        if (map == null) {
            return null;
        }
        try {
            Map entry = (Map)map.get((Object)this.getKey(filePath));
            return entry != null ? (DeploymentRevisionTracker.Revision)entry.get(DeploymentRevisionTrackerBase.getEntryKey(server)) : null;
        }
        catch (IOException e) {
            this.recreateMap(e);
            return null;
        }
    }

    private static String getEntryKey(Mappable server) {
        return Integer.toHexString(server.getId().hashCode());
    }

    @Override
    public synchronized void putBaseRevision(String localPath, Deployable server, @Nullable ThrowableComputable<DeploymentRevisionTracker.Revision, IOException> revision) throws IOException {
        HashMap<String, DeploymentRevisionTracker.Revision> entry;
        PersistentHashMap<String, Map<String, DeploymentRevisionTracker.Revision>> map = this.getMap(true);
        if (map == null) {
            return;
        }
        String key = this.getKey(localPath);
        try {
            entry = (HashMap<String, DeploymentRevisionTracker.Revision>)map.get((Object)key);
            if (entry == null) {
                if (revision == null) {
                    return;
                }
                entry = new HashMap<String, DeploymentRevisionTracker.Revision>();
            }
        }
        catch (IOException e) {
            map = this.recreateMap(e);
            if (map == null) {
                return;
            }
            if (revision == null) {
                return;
            }
            entry = new HashMap();
        }
        if (revision != null) {
            DeploymentRevisionTracker.Revision r = (DeploymentRevisionTracker.Revision)revision.compute();
            LOG.assertTrue((long)r.content.length <= MAX_FILE_SIZE);
            entry.put(DeploymentRevisionTrackerBase.getEntryKey(server), r);
        } else {
            entry.remove(DeploymentRevisionTrackerBase.getEntryKey(server));
        }
        try {
            if (entry.isEmpty()) {
                map.remove((Object)key);
            } else {
                map.put((Object)key, entry);
            }
        }
        catch (IOException e) {
            map = this.recreateMap(e);
            if (map == null || entry.isEmpty()) {
                return;
            }
            map.put((Object)key, entry);
        }
    }

    private String getKey(String localPath) {
        return this.myMacros.substitute(FileUtil.toSystemIndependentName((String)localPath), LocalFileSystem.getInstance().isCaseSensitive());
    }

    public void dispose() {
        this.closeMap();
    }

    protected synchronized void closeMap() {
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMap = null;
    }

    private static class MyValueExternaliser
    implements DataExternalizer<Map<String, DeploymentRevisionTracker.Revision>> {
        private static final int VERSION = 1;
        private static final int MINIMAL_SIZE_TO_ZIP = 5120;

        private MyValueExternaliser() {
        }

        public void save(@NotNull DataOutput out, Map<String, DeploymentRevisionTracker.Revision> value) throws IOException {
            if (out == null) {
                MyValueExternaliser.$$$reportNull$$$0(0);
            }
            out.writeByte(1);
            out.writeInt(value.size());
            for (Map.Entry<String, DeploymentRevisionTracker.Revision> e : value.entrySet()) {
                out.writeUTF(e.getKey());
                out.writeLong(e.getValue().timestamp);
                byte[] content = e.getValue().content;
                if (content.length > 5120) {
                    content = MyValueExternaliser.zip(content);
                    out.writeBoolean(true);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(content.length);
                out.write(content);
            }
        }

        public Map<String, DeploymentRevisionTracker.Revision> read(@NotNull DataInput in) throws IOException {
            byte version;
            if (in == null) {
                MyValueExternaliser.$$$reportNull$$$0(1);
            }
            if ((version = in.readByte()) != 1) {
                throw new IOException("Storage version is " + version + " while expected " + 1);
            }
            HashMap<String, DeploymentRevisionTracker.Revision> result = new HashMap<String, DeploymentRevisionTracker.Revision>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                long timestamp = in.readLong();
                boolean zipped = in.readBoolean();
                int contentLength = in.readInt();
                byte[] content = new byte[contentLength];
                in.readFully(content);
                if (zipped) {
                    content = MyValueExternaliser.unzip(content);
                }
                result.put(key, new DeploymentRevisionTracker.Revision(timestamp, content));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] zip(byte[] bytes) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            GZIPOutputStream dos = null;
            try {
                dos = new GZIPOutputStream(os);
                dos.write(bytes);
                dos.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return os.toByteArray();
        }

        private static byte[] unzip(byte[] bytes) {
            try {
                return StreamUtil.loadFromStream((InputStream)new GZIPInputStream(new ByteArrayInputStream(bytes)));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return new byte[0];
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentRevisionTrackerBase$MyValueExternaliser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

