/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.ConversionService;
import com.intellij.ide.impl.convert.ProjectFileVersion;
import com.intellij.ide.impl.convert.ProjectFileVersionState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFileVersion")
public class ProjectFileVersionImpl
extends ProjectFileVersion
implements Disposable,
PersistentStateComponent<ProjectFileVersionState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.convert.ProjectFileVersionImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFileVersion";
    private final Project myProject;
    private final ProjectFileVersionState myState = new ProjectFileVersionState();

    public ProjectFileVersionImpl(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        String path;
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String string = path = ProjectKt.isDirectoryBased(this.myProject) ? this.myProject.getBasePath() : this.myProject.getProjectFilePath();
        if (path == null) {
            LOG.info("Cannot save conversion result: filePath == null");
        } else {
            ConversionService.getInstance().saveConversionResult(FileUtil.toSystemDependentName((String)path));
        }
    }

    public ProjectFileVersionState getState() {
        if (this.myState != null && !this.myState.getPerformedConversionIds().isEmpty()) {
            return this.myState;
        }
        return null;
    }

    public void loadState(@NotNull ProjectFileVersionState state) {
        if (state == null) {
            ProjectFileVersionImpl.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/impl/convert/ProjectFileVersionImpl", "loadState"));
    }
}

