/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchQueryParser {
    public String searchQuery;

    @NotNull
    public static List<String> split(@NotNull String name, @Nullable String query) {
        int end;
        if (name == null) {
            SearchQueryParser.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        if (query == null) {
            result2.add(name);
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                SearchQueryParser.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        int length = name.length();
        int queryLength = query.length();
        int index = 0;
        while ((end = StringUtil.indexOfIgnoreCase((String)name, (String)query, (int)index)) != -1) {
            result2.add(name.substring(index, end));
            index = end + queryLength;
            result2.add(name.substring(end, index));
        }
        if (index < length) {
            result2.add(name.substring(index));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query) {
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(3);
        }
        ArrayList<String> words = new ArrayList<String>();
        int length = query.length();
        int index = 0;
        block0: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query.indexOf(34, index);
                if (end == -1) break;
                words.add(query.substring(index, end));
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index < length) {
                char nextCh;
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                words.add(query.substring(start2, nextCh == ' ' ? index - 1 : index));
                continue block0;
            }
        }
        if (words.isEmpty() && length > 0) {
            words.add(query);
        }
        ArrayList<String> arrayList = words;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected final void parse(@NotNull String query) {
        List<String> words;
        int size;
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(5);
        }
        if ((size = (words = SearchQueryParser.splitQuery(query)).size()) == 0) {
            return;
        }
        if (size == 1) {
            this.searchQuery = words.get(0);
            return;
        }
        int index = 0;
        while (index < size) {
            String name;
            if ((name = words.get(index++)).endsWith(":")) {
                if (index < size) {
                    boolean invert2 = name.startsWith("-");
                    name = name.substring(invert2 ? 1 : 0, name.length() - 1);
                    this.handleAttribute(name, words.get(index++), invert2);
                    continue;
                }
                this.searchQuery = query;
                return;
            }
            if (this.searchQuery == null) {
                this.searchQuery = name;
                continue;
            }
            this.searchQuery = query;
            return;
        }
    }

    protected abstract void handleAttribute(@NotNull String var1, @NotNull String var2, boolean var3);

    @NotNull
    public static String getTagQuery(@NotNull String tag) {
        if (tag == null) {
            SearchQueryParser.$$$reportNull$$$0(6);
        }
        String string = "tag:" + (tag.indexOf(32) == -1 ? tag : StringUtil.wrapWithDoubleQuote((String)tag));
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "splitQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTagQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Installed
    extends SearchQueryParser {
        public Boolean enabled;
        public Boolean bundled;
        public Boolean invalid;
        public Boolean needUpdate;
        public Boolean deleted;
        public Boolean needRestart;
        public final boolean attributes;

        public Installed(@NotNull String query) {
            if (query == null) {
                Installed.$$$reportNull$$$0(0);
            }
            for (String word : Installed.splitQuery(query)) {
                if (word.startsWith("#")) {
                    this.handleAttribute(word.substring(1), "", false);
                    continue;
                }
                if (word.startsWith("-#")) {
                    this.handleAttribute(word.substring(2), "", true);
                    continue;
                }
                if (this.searchQuery == null) {
                    this.searchQuery = word;
                    continue;
                }
                this.searchQuery = query;
                break;
            }
            this.attributes = this.enabled != null || this.bundled != null || this.invalid != null || this.needUpdate != null || this.deleted != null || this.needRestart != null;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert2) {
            if (name == null) {
                Installed.$$$reportNull$$$0(1);
            }
            if (value == null) {
                Installed.$$$reportNull$$$0(2);
            }
            switch (name) {
                case "enabled": {
                    this.enabled = !invert2;
                    break;
                }
                case "disabled": {
                    this.enabled = invert2;
                    break;
                }
                case "bundled": {
                    this.bundled = !invert2;
                    break;
                }
                case "custom": {
                    this.bundled = invert2;
                    break;
                }
                case "invalid": {
                    this.invalid = !invert2;
                    break;
                }
                case "outdated": {
                    this.needUpdate = !invert2;
                    break;
                }
                case "uninstalled": {
                    this.deleted = !invert2;
                    break;
                }
                case "inactive": {
                    this.needRestart = !invert2;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Installed";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Trending
    extends SearchQueryParser {
        public final Set<String> tags;
        public final Set<String> repositories;
        public String sortBy;

        public Trending(@NotNull String query) {
            if (query == null) {
                Trending.$$$reportNull$$$0(0);
            }
            this.tags = new HashSet<String>();
            this.repositories = new HashSet<String>();
            this.parse(query);
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if ("featured".equals(this.sortBy)) {
                url.append("is_featured_search=true");
            } else if ("updated".equals(this.sortBy)) {
                url.append("orderBy=update+date");
            } else if ("downloads".equals(this.sortBy)) {
                url.append("orderBy=downloads");
            } else if ("rating".equals(this.sortBy)) {
                url.append("orderBy=rating");
            } else if ("name".equals(this.sortBy)) {
                url.append("orderBy=name");
            }
            for (String tag : this.tags) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag));
            }
            if (this.searchQuery != null) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            String string = url.toString();
            if (string == null) {
                Trending.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert2) {
            if (name == null) {
                Trending.$$$reportNull$$$0(2);
            }
            if (value == null) {
                Trending.$$$reportNull$$$0(3);
            }
            if (name.equals("tag")) {
                this.tags.add(value);
            } else if (name.equals("sortBy")) {
                this.sortBy = value;
            } else if (name.equals("repository")) {
                this.repositories.add(value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser$Trending";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Trending";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

