/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml.behavior;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.CharTable;

public class DefaultXmlPsiPolicy
implements XmlPsiPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy");

    @Override
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text) {
        if (displayText.isEmpty()) {
            return null;
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(text.getNode());
        FileElement dummyParent = DummyHolderFactory.createHolder(text.getManager(), null, charTable).getTreeElement();
        XmlTag rootTag = ((XmlFile)PsiFileFactory.getInstance((Project)text.getProject()).createFileFromText("a.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)("<a>" + displayText + "</a>"), false, true)).getRootTag();
        assert (rootTag != null);
        XmlTagChild[] tagChildren = rootTag.getValue().getChildren();
        XmlTagChild child2 = tagChildren.length > 0 ? tagChildren[0] : null;
        LOG.assertTrue(child2 != null, (Object)("Child is null for tag: " + rootTag.getText()));
        TreeElement element = (TreeElement)child2.getNode();
        ((TreeElement)tagChildren[tagChildren.length - 1].getNode().getTreeNext()).rawRemoveUpToLast();
        dummyParent.rawAddChildren(element);
        TreeUtil.clearCaches(dummyParent);
        return element.getFirstChildNode();
    }
}

