/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.highlighter.HAMLHighlighter;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.HAMLVisitor;
import org.jetbrains.plugins.haml.psi.impl.HAMLAttributeImpl;

public class HAMLAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            HAMLAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HAMLAnnotator.$$$reportNull$$$0(1);
        }
        psiElement.accept((PsiElementVisitor)new HAMLAnnotatorVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/haml/highlighter/HAMLAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HAMLAnnotatorVisitor
    extends PsiElementVisitor
    implements HAMLVisitor {
        private final AnnotationHolder myHolder;
        private final IElementType myIndentTokenType;

        HAMLAnnotatorVisitor(@NotNull AnnotationHolder holder) {
            if (holder == null) {
                HAMLAnnotatorVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myIndentTokenType = HAMLTokenTypes.INDENT;
        }

        public void visitFile(PsiFile file) {
            PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)file);
            if (leaf instanceof PsiFile) {
                return;
            }
            if (leaf.getNode().getElementType() == this.myIndentTokenType) {
                this.myHolder.createErrorAnnotation(leaf, "Indenting at the beginning of the document is illegal");
            }
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element.getNode().getElementType() != HAMLTokenTypes.INDENT) {
                return;
            }
            if (element.getParent().getLanguage() != HAMLLanguage.INSTANCE) {
                return;
            }
            PsiElement exampleIndent = HAMLAnnotatorVisitor.findExampleIndent(element);
            if (exampleIndent == null || exampleIndent.getTextLength() == 0) {
                return;
            }
            if (HAMLAnnotatorVisitor.isIndentInconsistent(exampleIndent.getText())) {
                if (exampleIndent == element) {
                    this.myHolder.createErrorAnnotation(element, HamlBundle.message("illegal.mixed.indentation"));
                }
                return;
            }
            PsiElement next = element.getNextSibling();
            if (next == null || next instanceof PsiComment || next.getNode().getElementType() == HAMLTokenTypes.EOL) {
                return;
            }
            PsiFile file = element.getContainingFile();
            int endOffset = element.getTextRange().getEndOffset();
            if (file == null || file.getTextLength() <= endOffset) {
                return;
            }
            String indentText = element.getText();
            if (indentText.length() % exampleIndent.getTextLength() != 0 || HAMLAnnotatorVisitor.isIndentInconsistent(indentText) || HAMLAnnotatorVisitor.areIndentsCompatible(exampleIndent, indentText)) {
                String message = HamlBundle.message("inconsistent.indentation", HAMLAnnotatorVisitor.getIndentDescription(indentText), HAMLAnnotatorVisitor.getIndentDescription(exampleIndent.getText()));
                this.myHolder.createErrorAnnotation(element, message);
                return;
            }
            PsiElement parentIndent = element.getParent().getPrevSibling();
            if (parentIndent == null || parentIndent.getNode().getElementType() != HAMLTokenTypes.INDENT) {
                return;
            }
            int diff = indentText.length() - (parentIndent.getTextLength() + exampleIndent.getTextLength());
            if (diff > 0) {
                int level = diff / exampleIndent.getTextLength() + 1;
                String message = HamlBundle.message("inconsistent.indentation.levels.deeper", level);
                this.myHolder.createErrorAnnotation(element, message);
            }
        }

        private static PsiElement findExampleIndent(PsiElement element) {
            PsiFile file = element.getContainingFile();
            PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)file);
            PsiElement result = null;
            while (leaf != null) {
                if (leaf.getNode().getElementType() == HAMLTokenTypes.INDENT) {
                    result = leaf;
                    break;
                }
                leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
            }
            return result;
        }

        private static boolean areIndentsCompatible(PsiElement exampleIndent, String indentText) {
            return !indentText.contains(exampleIndent.getText());
        }

        private static boolean isIndentInconsistent(String s) {
            return s.contains(" ") && s.contains("\t");
        }

        private static String getIndentDescription(String s) {
            if (!s.contains(" ")) {
                return HamlBundle.message("indentation.tabs", s.length());
            }
            if (!s.contains("\t")) {
                return HamlBundle.message("indentation.spaces", s.length());
            }
            return '\"' + s.replaceAll("\t", "\\\\t") + '\"';
        }

        @Override
        public void visitHAMLAttribute(HAMLAttributeImpl attribute) {
            XmlElement element = attribute.getNameElement();
            if (element instanceof LeafElement) {
                LeafElement leaf = (LeafElement)element;
                int start = leaf.getStartOffset();
                TreeElement next = leaf.getTreeNext();
                int end = next != null && next.getElementType() == HAMLTokenTypes.EQUALS ? next.getTextOffset() + next.getTextLength() : leaf.getStartOffset() + leaf.getTextLength();
                this.myHolder.createInfoAnnotation(new TextRange(start, end), null).setTextAttributes(HAMLHighlighter.TAG_ATTR_KEY);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/haml/highlighter/HAMLAnnotator$HAMLAnnotatorVisitor", "<init>"));
        }
    }
}

