/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.util.containers.ContainerUtilRt;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class Db2JdbcHelper
extends JdbcHelperImpl {
    private static final Pattern DB2_VERSION_PATTERN = Pattern.compile("SQL(\\d\\d)(\\d\\d)(\\d+)");
    private static final Set<String> DB2_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "smallint", "boolean", "bigint", "double", "real", "date", "time", "xml"});
    private static final Set<String> DB2_TWICE_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"graphic", "vargraphic", "dbclob"});

    public Db2JdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of((String)"DB2"), version, connection);
    }

    public Db2JdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return Db2JdbcHelper.extractVersion(version);
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            Db2JdbcHelper.$$$reportNull$$$0(0);
        }
        if (value == null) {
            Db2JdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Class<?> c = o.getClass();
        String className = c.getName();
        if (className.equals("com.ibm.db2.jcc.am.ke") || className.equals("com.ibm.db2.jcc.am.bf")) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return super.convertValue(exporter, o);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            Db2JdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DB2_UNLIMITED_TYPES.contains(t) || e.length == 0) {
            e.length = -1;
        } else if (t.equals("timestamp")) {
            e.length = e.scale;
            e.scale = 0;
        } else if (DB2_TWICE_TYPES.contains(t)) {
            e.length /= 2;
        }
        Db2JdbcHelper.processForBitData(e);
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            Db2JdbcHelper.$$$reportNull$$$0(3);
        }
        if (!JdbcNativeUtil.detectString(product, "db2")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return Db2JdbcHelper.create(delegate);
    }

    @NotNull
    private static Db2JdbcHelper create(@NotNull Connection delegate) throws Exception {
        DatabaseMetaData md;
        if (delegate == null) {
            Db2JdbcHelper.$$$reportNull$$$0(4);
        }
        String versionStr = (md = delegate.getMetaData()) == null ? null : md.getDatabaseProductVersion();
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + versionStr);
        Db2JdbcHelper db2JdbcHelper = new Db2JdbcHelper(Db2JdbcHelper.extractVersion(versionStr), delegate);
        if (db2JdbcHelper == null) {
            Db2JdbcHelper.$$$reportNull$$$0(5);
        }
        return db2JdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = DB2_VERSION_PATTERN.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String s = matcher.group(1);
        if (s.startsWith("0")) {
            s = s.substring(1);
        }
        return s + "." + matcher.group(2) + "." + matcher.group(3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/Db2JdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/Db2JdbcHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

