/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.log.LogMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.DualListener;
import org.netbeans.lib.cvsclient.event.ICvsListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.FileInfoAndMessageResponseProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public class LogCommand
extends AbstractCommand {
    @NonNls
    private static final String EXAM_DIR = " server: Logging ";
    private boolean defaultBranch;
    private String dateFilter;
    private boolean headerOnly;
    private boolean noTags;
    private String revisionFilter;
    private String stateFilter;
    private String userFilter;
    private boolean headerAndDescOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.LOG, clientEnvironment);
        requests.addArgumentRequest(this.isDefaultBranch(), "-b");
        requests.addArgumentRequest(this.isHeaderAndDescOnly(), "-t");
        requests.addArgumentRequest(this.isHeaderOnly(), "-h");
        requests.addArgumentRequest(this.isNoTags(), "-N");
        requests.addArgumentRequest(this.getUserFilter(), "-w");
        requests.addArgumentRequest(this.getRevisionFilter(), "-r");
        requests.addArgumentRequest(this.getStateFilter(), "-s");
        requests.addArgumentRequest(this.getDateFilter(), "-d");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        FileStateRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);
        FileInfoAndMessageResponseProgressHandler responseProgressHandler = new FileInfoAndMessageResponseProgressHandler(new RangeProgressViewer(progressViewer, 0.5, 1.0), cvsFiles, EXAM_DIR);
        ICvsListener parser = this.createParser(eventSender, clientEnvironment.getCvsFileSystem());
        DualListener listener = new DualListener(parser, responseProgressHandler);
        listener.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, requestsProgressHandler);
            return bl;
        }
        finally {
            listener.unregisterListeners(listenerRegistry);
        }
    }

    protected ICvsListener createParser(IEventSender eventSender, ICvsFileSystem cvsFileSystem) {
        return new LogMessageParser(eventSender, cvsFileSystem);
    }

    @Override
    public final String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("log ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public final void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setDefaultBranch(false);
        this.setHeaderOnly(false);
        this.setHeaderAndDescOnly(false);
        this.setNoTags(false);
        this.setDateFilter(null);
        this.setRevisionFilter(null);
        this.setStateFilter(null);
        this.setUserFilter(null);
    }

    private boolean isDefaultBranch() {
        return this.defaultBranch;
    }

    public final void setDefaultBranch(boolean defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    private String getDateFilter() {
        return this.dateFilter;
    }

    public final void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    private boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public final void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    private boolean isNoTags() {
        return this.noTags;
    }

    public final void setNoTags(boolean noTags) {
        this.noTags = noTags;
    }

    private String getRevisionFilter() {
        return this.revisionFilter;
    }

    public final void setRevisionFilter(String revisionFilter) {
        this.revisionFilter = revisionFilter;
    }

    private String getStateFilter() {
        return this.stateFilter;
    }

    public final void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    private String getUserFilter() {
        return this.userFilter;
    }

    public final void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    private boolean isHeaderAndDescOnly() {
        return this.headerAndDescOnly;
    }

    public final void setHeaderAndDescOnly(boolean headerAndDescOnly) {
        this.headerAndDescOnly = headerAndDescOnly;
    }

    private String getCVSArguments() {
        StringBuilder cvsArguments = new StringBuilder();
        if (this.isDefaultBranch()) {
            cvsArguments.append("-b ");
        }
        if (this.isHeaderAndDescOnly()) {
            cvsArguments.append("-t ");
        }
        if (this.isHeaderOnly()) {
            cvsArguments.append("-h ");
        }
        if (this.isNoTags()) {
            cvsArguments.append("-N ");
        }
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.userFilter != null) {
            cvsArguments.append("-w");
            cvsArguments.append(this.userFilter);
            cvsArguments.append(' ');
        }
        if (this.revisionFilter != null) {
            cvsArguments.append("-r");
            cvsArguments.append(this.revisionFilter);
            cvsArguments.append(' ');
        }
        if (this.stateFilter != null) {
            cvsArguments.append("-s");
            cvsArguments.append(this.stateFilter);
            cvsArguments.append(' ');
        }
        if (this.dateFilter != null) {
            cvsArguments.append("-d");
            cvsArguments.append(this.dateFilter);
            cvsArguments.append(' ');
        }
        return cvsArguments.toString();
    }

    @Override
    protected final void addModifiedRequest(FileObject fileObject, Entry entry, Requests requests, IClientEnvironment clientEnvironment) {
        requests.addIsModifiedRequest(fileObject);
    }
}

