/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sql92;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sql92.Sql92Tokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Sql92Dialect
extends SqlLanguageDialectEx {
    public static final Sql92Dialect INSTANCE = new Sql92Dialect();

    public Sql92Dialect() {
        super("SQL92");
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            Sql92Dialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("SQL92" == null) {
            Sql92Dialect.$$$reportNull$$$0(1);
        }
        return "SQL92";
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            Sql92Dialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            Sql92Dialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            Sql92Dialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            Sql92Dialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (PsiUtilCore.getElementType((PsiElement)o.getFirstChild()) == SqlTokens.SQL_MODULE) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            Sql92Dialect.$$$reportNull$$$0(6);
        }
        return element2 == SqlCompositeElementTypes.SQL_STRING_LITERAL || element2 == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element2 == SqlCompositeElementTypes.SQL_IDENTIFIER || element2 == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            Sql92Dialect.$$$reportNull$$$0(7);
        }
        if ("character".equals(name = super.getNormalizedTypeName(name))) {
            if ("char" == null) {
                Sql92Dialect.$$$reportNull$$$0(8);
            }
            return "char";
        }
        if ("char varying".equals(name)) {
            if ("varchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(9);
            }
            return "varchar";
        }
        if ("character varying".equals(name)) {
            if ("varchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(10);
            }
            return "varchar";
        }
        if ("national char".equals(name)) {
            if ("nchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(11);
            }
            return "nchar";
        }
        if ("national character".equals(name)) {
            if ("nchar" == null) {
                Sql92Dialect.$$$reportNull$$$0(12);
            }
            return "nchar";
        }
        if ("national char varying".equals(name)) {
            if ("nchar varying" == null) {
                Sql92Dialect.$$$reportNull$$$0(13);
            }
            return "nchar varying";
        }
        if ("national character varying".equals(name)) {
            if ("nchar varying" == null) {
                Sql92Dialect.$$$reportNull$$$0(14);
            }
            return "nchar varying";
        }
        if ("dec".equals(name)) {
            if ("decimal" == null) {
                Sql92Dialect.$$$reportNull$$$0(15);
            }
            return "decimal";
        }
        if ("int".equals(name)) {
            if ("integer" == null) {
                Sql92Dialect.$$$reportNull$$$0(16);
            }
            return "integer";
        }
        String string = name;
        if (string == null) {
            Sql92Dialect.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            Sql92Dialect.$$$reportNull$$$0(18);
        }
        if ("bit".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(19);
            }
            return category;
        }
        if ("bit varying".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(20);
            }
            return category;
        }
        if ("numeric".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(21);
            }
            return category;
        }
        if ("decimal".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                Sql92Dialect.$$$reportNull$$$0(22);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            Sql92Dialect.$$$reportNull$$$0(23);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/sql92/Sql92Dialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/sql92/Sql92Dialect";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(Sql92Tokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_OVERLAPS, SqlTokens.SQL_MATCH, SqlTokens.SQL_AT, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR});
        }
    }
}

