/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.scss.SCSSLanguage;

public class SassExtensionFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                SassExtensionFileReferenceHelper.$$$reportNull$$$0(1);
            }
            return list;
        }
        LinkedList result = ContainerUtil.newLinkedList();
        for (SassExtension sassExtension : SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file)) {
            result.addAll(sassExtension.getStylesheetsRoots(module));
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            result.add(parent);
        }
        List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Collection)result, file1 -> this.getPsiFileSystemItem(project, (VirtualFile)file1)));
        if (list == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if (!this.isMyFile(project, file)) {
            return false;
        }
        return SassExtensionFileReferenceHelper.getAppropriateSassExtensions(project, file).size() > 0;
    }

    @NotNull
    private static Collection<SassExtension> getAppropriateSassExtensions(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(5);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            List<SassExtension> list = Collections.emptyList();
            if (list == null) {
                SassExtensionFileReferenceHelper.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<SassExtension> collection = SassExtension.getAllExtensions(module);
        if (collection == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(8);
        }
        return collection;
    }

    protected boolean isMyFile(@NotNull Project project, @NotNull VirtualFile file) {
        String extension;
        if (project == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(9);
        }
        if (file == null) {
            SassExtensionFileReferenceHelper.$$$reportNull$$$0(10);
        }
        if ("sass".equalsIgnoreCase(extension = file.getExtension()) || "scss".equalsIgnoreCase(extension)) {
            return true;
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        if (item instanceof PsiFile) {
            Set allLanguages = ((PsiFile)item).getViewProvider().getLanguages();
            return allLanguages.contains((Object)SASSLanguage.INSTANCE) || allLanguages.contains((Object)SCSSLanguage.INSTANCE);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/SassExtensionFileReferenceHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateSassExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateSassExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMyFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

