/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class Angular2LangUtil {
    private static final Key<CachedValue<Boolean>> ANGULAR2_CONTEXT_KEY = new Key("angular2.isContext");

    public static boolean isAngular2Context(@NotNull PsiElement context) {
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(0);
        }
        if (!context.isValid()) {
            return false;
        }
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)context.getProject()).getTopLevelFile(context);
        if (psiFile == null) {
            return false;
        }
        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
        if (file == null || !file.isInLocalFileSystem()) {
            return Angular2LangUtil.isAngular2Context(psiFile.getProject());
        }
        return Angular2LangUtil.isAngular2Context(psiFile.getProject(), file);
    }

    public static boolean isAngular2Context(@NotNull Project project, @NotNull VirtualFile context) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        while (context instanceof LightVirtualFileBase) {
            context = ((LightVirtualFileBase)context).getOriginalFile();
        }
        PsiDirectory psiDir = (PsiDirectory)ObjectUtils.doIfNotNull((Object)(context != null ? context.getParent() : null), dir -> {
            if (project == null) {
                Angular2LangUtil.$$$reportNull$$$0(7);
            }
            return dir.isValid() ? PsiManager.getInstance((Project)project).findDirectory(dir) : null;
        });
        if (psiDir == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiDir, ANGULAR2_CONTEXT_KEY, () -> {
            if (project == null) {
                Angular2LangUtil.$$$reportNull$$$0(6);
            }
            return new CachedValueProvider.Result((Object)Angular2LangUtil.isAngular2ContextDir(psiDir), new Object[]{PackageJsonFileManager.getInstance((Project)project).getModificationTracker()});
        });
    }

    @Deprecated
    public static boolean isAngular2Context(@NotNull Project project) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(3);
        }
        if (project.getBaseDir() != null) {
            return Angular2LangUtil.isAngular2Context(project, project.getBaseDir());
        }
        return false;
    }

    private static boolean isAngular2ContextDir(@NotNull PsiDirectory psiDir) {
        if (psiDir == null) {
            Angular2LangUtil.$$$reportNull$$$0(4);
        }
        VirtualFile dir = psiDir.getVirtualFile();
        PackageJsonFileManager manager = PackageJsonFileManager.getInstance((Project)psiDir.getProject());
        String dirPath = (String)ObjectUtils.notNull((Object)dir.getCanonicalPath(), () -> ((VirtualFile)dir).getPath()) + "/";
        for (VirtualFile config : manager.getValidPackageJsonFiles()) {
            PackageJsonData data;
            if (!dirPath.startsWith((String)ObjectUtils.notNull((Object)config.getParent().getCanonicalPath(), () -> ((VirtualFile)dir).getPath()) + "/") || !(data = PackageJsonUtil.getOrCreateData((VirtualFile)config)).isDependencyOfAnyType("@angular/core")) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirective(@NotNull String decoratorName) {
        if (decoratorName == null) {
            Angular2LangUtil.$$$reportNull$$$0(5);
        }
        return "Directive".equals(decoratorName) || "Component".equals(decoratorName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorName";
                break;
            }
        }
        objectArray2[1] = "org/angular2/lang/Angular2LangUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAngular2Context";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAngular2ContextDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirective";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isAngular2Context$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isAngular2Context$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

