/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import java.awt.Component;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "globalVariables", "Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "getGlobalVariables", "()Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "globalVariables$delegate", "Lkotlin/Lazy;", "localVariables", "Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "getLocalVariables", "()Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "variableWillBeAdded", "", "beforeExecution", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "execute", "text", "", "isEmptyCommandExecutionAllowed", "Companion", "intellij.javascript.debugger"})
public final class JavaScriptDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final LocalVariablesHolder localVariables;
    @NotNull
    private final Lazy globalVariables$delegate;
    private boolean variableWillBeAdded;
    private static final Key<Object> STRING_KEY;
    private static final Key<Object> NUMBER_KEY;
    private static final Key<Object> KEYWORD_KEY;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaScriptDebuggerConsoleExecuteActionHandler.class), "globalVariables", "getGlobalVariables()Lcom/intellij/javascript/debugger/GlobalVariablesHolder;"))};
        Companion = new Companion(null);
        STRING_KEY = new Key("JS_DEBUG_STRING");
        NUMBER_KEY = new Key("JS_DEBUG_NUMBER");
        KEYWORD_KEY = new Key("JS_DEBUG_KEYWORD");
        ConsoleViewContentType.registerNewConsoleViewType(STRING_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType(NUMBER_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ConsoleViewContentType.registerNewConsoleViewType(KEYWORD_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    @NotNull
    public final LocalVariablesHolder getLocalVariables() {
        return this.localVariables;
    }

    @NotNull
    public final GlobalVariablesHolder getGlobalVariables() {
        Lazy lazy = this.globalVariables$delegate;
        JavaScriptDebuggerConsoleExecuteActionHandler javaScriptDebuggerConsoleExecuteActionHandler = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (GlobalVariablesHolder)lazy.getValue();
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    protected void beforeExecution(@NotNull LanguageConsoleView console) {
        Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
        console.getFile().accept((PsiElementVisitor)new PsiVisitors.FilteringPsiRecursiveElementWalkingVisitor(this){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof JSVarStatement) {
                    JavaScriptDebuggerConsoleExecuteActionHandler.access$setVariableWillBeAdded$p(this.this$0, true);
                    this.stopWalking();
                } else if (!(element instanceof JSFunction)) {
                    super.visitElement(element);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)console.getComponent());
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"DataManager.getInstance(\u2026ontext(console.component)");
        DataContext dataContext2 = dataContext;
        XDebugSession xDebugSession = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext2);
        if (xDebugSession == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebugSession.DATA_KEY.g\u2026ta(dataContext) ?: return");
        XDebugSession session = xDebugSession;
        XDebugProcess xDebugProcess = session.getDebugProcess();
        if (xDebugProcess == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<*>");
        }
        JavaScriptDebugProcess debugProcess = (JavaScriptDebugProcess)xDebugProcess;
        CallFrameView currentCallFrame = (CallFrameView)session.getCurrentStackFrame();
        boolean variableWillBeAdded = this.variableWillBeAdded;
        this.variableWillBeAdded = false;
        CallFrameView callFrameView = currentCallFrame;
        if (callFrameView == null || (callFrameView = callFrameView.getEvaluateContext()) == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            if ((callFrameView = vm.getEvaluateContext()) == null) {
                Intrinsics.throwNpe();
            }
        }
        EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)callFrameView, (String)text, null, (boolean)true, (Project)session.getProject(), (int)2, null).onSuccess((Consumer)new Consumer<EvaluateResult>(this, console, debugProcess, text, variableWillBeAdded, currentCallFrame, session){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            final /* synthetic */ LanguageConsoleView $console;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $variableWillBeAdded;
            final /* synthetic */ CallFrameView $currentCallFrame;
            final /* synthetic */ XDebugSession $session;

            /*
             * WARNING - void declaration
             */
            public final void accept(EvaluateResult it) {
                if (it.getWasThrown()) {
                    this.$console.print("\u200c", ConsoleViewContentType.ERROR_OUTPUT);
                    GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                    Value value = it.getValue();
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                    globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType, (ConsoleView)this.$console);
                    this.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
                    return;
                }
                if (this.$variableWillBeAdded) {
                    if (this.$currentCallFrame == null) {
                        this.this$0.getGlobalVariables().update();
                    } else if (Intrinsics.areEqual((Object)this.$currentCallFrame, (Object)this.$session.getCurrentStackFrame())) {
                        CallFrame callFrame = this.$currentCallFrame.getCallFrame();
                        this.this$0.getLocalVariables().setCallFrame(callFrame);
                        Scope localScope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(callFrame);
                        if (localScope != null) {
                            void $receiver$iv;
                            Promise promise2 = localScope.getVariablesHost().clearCaches();
                            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"localScope.variablesHost.clearCaches()");
                            Promise promise3 = promise2;
                            Promise promise4 = $receiver$iv.onSuccess((Consumer)new Consumer<Object>(this){
                                final /* synthetic */ execute.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void accept(Object it) {
                                    this.this$0.this$0.getLocalVariables().update();
                                    this.this$0.$debugProcess.getSession().rebuildViews();
                                }
                            });
                            Intrinsics.checkExpressionValueIsNotNull((Object)promise4, (String)"onSuccess { handler() }");
                            promise4.onError((Consumer)new RejectErrorReporter(this.$session, null, 2, null));
                        }
                    }
                }
                this.$console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
                GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                Value value = it.getValue();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler$Companion.access$getValueKey(JavaScriptDebuggerConsoleExecuteActionHandler.Companion, it.getValue()));
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026pe(getValueKey(it.value))");
                globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType, (ConsoleView)this.$console);
                this.$console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            {
                this.this$0 = javaScriptDebuggerConsoleExecuteActionHandler;
                this.$console = languageConsoleView;
                this.$debugProcess = javaScriptDebugProcess;
                this.$text = string;
                this.$variableWillBeAdded = bl;
                this.$currentCallFrame = callFrameView;
                this.$session = xDebugSession;
            }
        }).onError((Consumer)new Consumer<Throwable>(console){
            final /* synthetic */ LanguageConsoleView $console;

            public final void accept(Throwable it) {
                this.$console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
                String string = it.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$console.print(string, ConsoleViewContentType.ERROR_OUTPUT);
                this.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$console = languageConsoleView;
            }
        });
    }

    public JavaScriptDebuggerConsoleExecuteActionHandler(final @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(true);
        this.localVariables = new LocalVariablesHolder((DebuggerViewSupport)debugProcess.getDebuggerViewSupport());
        this.globalVariables$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalVariablesHolder>(debugProcess){
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GlobalVariablesHolder invoke() {
                void var1_1;
                GlobalVariablesHolder holder = new GlobalVariablesHolder((DebuggerViewSupport)this.$debugProcess.getDebuggerViewSupport());
                holder.update();
                return var1_1;
            }
            {
                this.$debugProcess = javaScriptDebugProcess;
                super(0);
            }
        }));
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private final void updateConsoleContext() {
                this.getLocalVariables().setCallFrame(null);
                XDebugSession session = debugProcess.getSession();
                ConsoleView consoleView = debugProcess.getJSConsoleView(false);
                if (!(consoleView instanceof LanguageConsoleView)) {
                    consoleView = null;
                }
                LanguageConsoleView languageConsoleView = (LanguageConsoleView)consoleView;
                if (languageConsoleView == null) {
                    return;
                }
                LanguageConsoleView consoleView2 = languageConsoleView;
                XDebugSession xDebugSession = session;
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                XSourcePosition position = xDebugSession.getCurrentPosition();
                ApplicationManager.getApplication().runReadAction(new Computable<T>(session, consoleView2, position){
                    final /* synthetic */ XDebugSession $session$inlined;
                    final /* synthetic */ LanguageConsoleView $consoleView$inlined;
                    final /* synthetic */ XSourcePosition $position$inlined;
                    {
                        this.$session$inlined = xDebugSession;
                        this.$consoleView$inlined = languageConsoleView;
                        this.$position$inlined = xSourcePosition;
                    }

                    public final T compute() {
                        XDebugSession xDebugSession = this.$session$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                        Project project = xDebugSession.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
                        if (!project.isDisposed()) {
                            PsiFile psiFile = this.$consoleView$inlined.getFile();
                            if (psiFile == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl");
                            }
                            JSExpressionCodeFragmentImpl consolePsiFile = (JSExpressionCodeFragmentImpl)psiFile;
                            if (this.$position$inlined == null || this.$position$inlined.getOffset() < 0) {
                                consolePsiFile.setContext((PsiElement)null);
                            } else {
                                PsiFile contextPsiFile;
                                XDebugSession xDebugSession2 = this.$session$inlined;
                                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession2, (String)"session");
                                PsiFile psiFile2 = contextPsiFile = PsiManager.getInstance((Project)xDebugSession2.getProject()).findFile(this.$position$inlined.getFile());
                                PsiElement context = psiFile2 != null ? psiFile2.findElementAt(this.$position$inlined.getOffset()) : null;
                                consolePsiFile.setContext(context);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }

            public void sessionStopped() {
                this.updateConsoleContext();
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }
        });
    }

    public static final /* synthetic */ boolean access$getVariableWillBeAdded$p(JavaScriptDebuggerConsoleExecuteActionHandler $this) {
        return $this.variableWillBeAdded;
    }

    public static final /* synthetic */ void access$setVariableWillBeAdded$p(JavaScriptDebuggerConsoleExecuteActionHandler $this, boolean bl) {
        $this.variableWillBeAdded = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0001 \b*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u00042\u0006\u0010\t\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerConsoleExecuteActionHandler$Companion;", "", "()V", "KEYWORD_KEY", "Lcom/intellij/openapi/util/Key;", "NUMBER_KEY", "STRING_KEY", "getValueKey", "kotlin.jvm.PlatformType", "value", "Lorg/jetbrains/debugger/values/Value;", "intellij.javascript.debugger"})
    public static final class Companion {
        private final Key<Object> getValueKey(Value value) {
            Key key;
            switch (JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: 
                case 2: {
                    key = STRING_KEY;
                    break;
                }
                case 3: {
                    key = NUMBER_KEY;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    key = KEYWORD_KEY;
                    break;
                }
                default: {
                    key = ProcessOutputTypes.STDOUT;
                }
            }
            return key;
        }

        private Companion() {
        }

        public static final /* synthetic */ Key access$getValueKey(Companion $this, @NotNull Value value) {
            return $this.getValueKey(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

