/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.action.DockerDeleteProvider;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.TreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StatusText;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerViewContribution
extends RemoteServersViewContribution {
    @NonNls
    private static final String HELP_ID = "reference.docker.tool.window";

    public List<RemoteServer<?>> getRemoteServers() {
        return new ArrayList(RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()));
    }

    public void setupAvailabilityListener(@NotNull Project project, @NotNull Runnable checkAvailability) {
        if (project == null) {
            DockerViewContribution.$$$reportNull$$$0(0);
        }
        if (checkAvailability == null) {
            DockerViewContribution.$$$reportNull$$$0(1);
        }
    }

    public void setupTree(Project project, Tree tree, TreeBuilderBase builder) {
        String after;
        ActionListener settingsOpener = evt -> ShowSettingsUtil.getInstance().showSettingsDialog(project, DockerCloudType.getInstance().getPresentableName());
        StatusText emptyText = tree.getEmptyText();
        SimpleTextAttributes nonLinkAttributes = StatusText.DEFAULT_ATTRIBUTES;
        String LINK_START = "<a>";
        String LINK_END = "</a>";
        String text = DockerBundle.getText("DockerViewContribution.emptyText", new Object[0]);
        String before = StringUtil.substringBefore((String)text, (String)"<a>");
        if (before != null) {
            emptyText.appendText(before, nonLinkAttributes);
            text = StringUtil.trimStart((String)text, (String)(before + "<a>"));
        }
        if ((after = StringUtil.substringAfter((String)text, (String)"</a>")) != null) {
            String link = StringUtil.trimEnd((String)text, (String)("</a>" + after));
            emptyText.appendText(link, SimpleTextAttributes.LINK_ATTRIBUTES, settingsOpener);
            emptyText.appendText(after, nonLinkAttributes);
        } else {
            emptyText.appendText(text, nonLinkAttributes);
        }
    }

    @NotNull
    public List<AbstractTreeNode<?>> createServerNodes(Project project) {
        List<AbstractTreeNode<?>> list = Collections.emptyList();
        if (list == null) {
            DockerViewContribution.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull ServersToolWindowContent content) {
        if (dataId == null) {
            DockerViewContribution.$$$reportNull$$$0(3);
        }
        if (content == null) {
            DockerViewContribution.$$$reportNull$$$0(4);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DockerDeleteProvider();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Project project = content.getProject();
            List<DockerApplicationRuntime> runtimes = this.getSelectedRuntimes(content);
            return runtimes.stream().map(rt -> rt.computeNavigatable(project)).filter(Objects::nonNull).toArray(Navigatable[]::new);
        }
        return null;
    }

    public ServersTreeStructure createTreeStructure(@NotNull Project project, @NotNull ServersTreeNodeSelector nodeSelector) {
        if (project == null) {
            DockerViewContribution.$$$reportNull$$$0(5);
        }
        if (nodeSelector == null) {
            DockerViewContribution.$$$reportNull$$$0(6);
        }
        return new DockerTreeStructure(project, this, nodeSelector);
    }

    public TreeNodeSelector createLogNodeSelector(final ServerConnection<?> connection, final String deploymentName, final String logName) {
        return new TreeNodeSelector<DockerTreeStructure.DockerDeploymentNode>(){

            public boolean visit(@NotNull DockerTreeStructure.DockerDeploymentNode node) {
                boolean result;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result = ServersToolWindowContent.isDeploymentNodeMatch((ServersTreeStructure.DeploymentNodeImpl)node, (ServerConnection)connection, (String)deploymentName)) {
                    node.selectLog(logName);
                }
                return result;
            }

            public Class<DockerTreeStructure.DockerDeploymentNode> getNodeClass() {
                return DockerTreeStructure.DockerDeploymentNode.class;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/docker/view/DockerViewContribution$1", "visit"));
            }
        };
    }

    protected String getContextHelpId() {
        return HELP_ID;
    }

    @NotNull
    private List<DockerApplicationRuntime> getSelectedRuntimes(@NotNull ServersToolWindowContent content) {
        if (content == null) {
            DockerViewContribution.$$$reportNull$$$0(7);
        }
        List<DockerApplicationRuntime> list = content.getBuilder().getSelectedElements().stream().map(o -> (DockerTreeStructure.DockerDeploymentNode)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerTreeStructure.DockerDeploymentNode.class)))).filter(Objects::nonNull).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).map(Deployment::getRuntime).map(rt -> (DockerApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)rt, DockerApplicationRuntime.class)))).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DockerViewContribution.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkAvailability";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/DockerViewContribution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/DockerViewContribution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createServerNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRuntimes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupAvailabilityListener";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTreeStructure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRuntimes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

