/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GithubDataLoadingComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestDetailsPanel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubDataLoadingComponent;", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailedWithHtml;", "Lcom/intellij/openapi/Disposable;", "iconProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;)V", "detailsPanel", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "dispose", "", "handleError", "error", "", "handleResult", "result", "reset", "setBusy", "busy", "", "updateUI", "Companion", "intellij.vcs.github"})
public final class GithubPullRequestDetailsComponent
extends GithubDataLoadingComponent<GithubPullRequestDetailedWithHtml>
implements Disposable {
    private final GithubPullRequestDetailsPanel detailsPanel;
    private final JBLoadingPanel loadingPanel;
    private static final String DEFAULT_EMPTY_TEXT = "Select pull request to view details";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void reset() {
        this.detailsPanel.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.detailsPanel.setDetails(null);
    }

    @Override
    protected void handleResult(@NotNull GithubPullRequestDetailedWithHtml result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        this.detailsPanel.setDetails(result);
    }

    @Override
    protected void handleError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        StatusText statusText = this.detailsPanel.getEmptyText().clear().appendText("Cannot load details", SimpleTextAttributes.ERROR_ATTRIBUTES);
        String string = error.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        statusText.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
    }

    @Override
    protected void setBusy(boolean busy) {
        if (busy) {
            this.detailsPanel.getEmptyText().clear();
            this.loadingPanel.startLoading();
        } else {
            this.loadingPanel.stopLoading();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIUtil.getListBackground());
    }

    public void dispose() {
    }

    public GithubPullRequestDetailsComponent(@NotNull CachingGithubAvatarIconsProvider.Factory iconProviderFactory) {
        JBLoadingPanel jBLoadingPanel;
        Intrinsics.checkParameterIsNotNull((Object)iconProviderFactory, (String)"iconProviderFactory");
        this.detailsPanel = new GithubPullRequestDetailsPanel(iconProviderFactory);
        JBLoadingPanel jBLoadingPanel2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        GithubPullRequestDetailsComponent githubPullRequestDetailsComponent = this;
        JBLoadingPanel $receiver = jBLoadingPanel2;
        $receiver.setOpaque(false);
        githubPullRequestDetailsComponent.loadingPanel = jBLoadingPanel = jBLoadingPanel2;
        this.setOpaque(true);
        this.detailsPanel.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.loadingPanel.add((Component)((Object)this.detailsPanel));
        this.setContent((JComponent)this.loadingPanel);
        Disposer.register((Disposable)this, (Disposable)this.detailsPanel);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent$Companion;", "", "()V", "DEFAULT_EMPTY_TEXT", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

