/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.login;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.ThreeState;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public abstract class CvsLoginWorkerImpl<T extends CvsConnectionSettings>
implements CvsLoginWorker {
    protected final Project myProject;
    protected final T mySettings;

    protected CvsLoginWorkerImpl(Project project, T settings) {
        this.myProject = project;
        this.mySettings = settings;
    }

    protected abstract void silentLoginImpl(boolean var1) throws AuthenticationException;

    protected abstract void clearOldCredentials();

    public ThreeState silentLogin(boolean forceCheck) throws AuthenticationException {
        if (((CvsConnectionSettings)((Object)this.mySettings)).isOffline()) {
            return ThreeState.NO;
        }
        try {
            this.silentLoginImpl(forceCheck);
        }
        catch (AuthenticationException e) {
            if (e.isSolveable()) {
                this.clearOldCredentials();
                return ThreeState.UNSURE;
            }
            throw e;
        }
        return ThreeState.YES;
    }

    public void goOffline() {
        ((CvsConnectionSettings)((Object)this.mySettings)).setOffline(true);
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)CvsBundle.message((String)"set.offline.notification.text", (Object[])new Object[0]), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
    }

    public static void showConnectionErrorMessage(Project project, String message) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)message, (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
    }
}

