/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ObjectUtils;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public interface ShimsBasedVersionManagerHandler {
    @NotNull
    public Path computeShimsPath(@NotNull Sdk var1);

    @Contract(value="null, null -> null")
    @Nullable
    public static Path shimsPathFor(@Nullable Sdk sdk, @Nullable Module module) {
        Sdk sdk2 = RubySdkUtil.getEffectiveSdk(sdk, module);
        ShimsBasedVersionManagerHandler shimsBasedVersionManagerHandler2 = ShimsBasedVersionManagerHandler.from(sdk2);
        return (Path)ObjectUtils.doIfNotNull((Object)shimsBasedVersionManagerHandler2, shimsBasedVersionManagerHandler -> shimsBasedVersionManagerHandler.computeShimsPath(Objects.requireNonNull(sdk2)));
    }

    @Contract(value="null-> null")
    @Nullable
    public static ShimsBasedVersionManagerHandler from(@Nullable Sdk sdk) {
        return (ShimsBasedVersionManagerHandler)ObjectUtils.tryCast((Object)RubyVersionManagerHandler.from(sdk), ShimsBasedVersionManagerHandler.class);
    }

    @Contract(value="null -> false")
    public static boolean is(@Nullable Sdk sdk) {
        return ShimsBasedVersionManagerHandler.is(RubyVersionManagerHandler.from(sdk));
    }

    @Contract(value="null -> false")
    public static boolean is(@Nullable RubyVersionManagerHandler versionManagerHandler) {
        return versionManagerHandler instanceof ShimsBasedVersionManagerHandler;
    }
}

