/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.impl.VcsChangesMerger;
import com.intellij.vcs.log.visible.VisiblePack;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUtil {
    @Nullable
    public static VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (!VcsHistoryUtil.isEmpty(revision) && revision instanceof VcsFileRevisionEx) {
            FilePath path = ((VcsFileRevisionEx)revision).getPath();
            return path.isDirectory() ? new VcsVirtualFolder(path.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(path.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @NotNull
    public static List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details, @NotNull Condition<? super Change> isRelevant) {
        List changes2;
        if (details == null) {
            FileHistoryUtil.$$$reportNull$$$0(0);
        }
        if (isRelevant == null) {
            FileHistoryUtil.$$$reportNull$$$0(1);
        }
        if (!(changes2 = ContainerUtil.filter((Collection)details.getChanges(), isRelevant)).isEmpty()) {
            List list2 = changes2;
            if (list2 == null) {
                FileHistoryUtil.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (details.getParents().size() > 1) {
            for (int parent = 0; parent < details.getParents().size(); ++parent) {
                List changesToParent = ContainerUtil.filter((Collection)details.getChanges(parent), isRelevant);
                if (changesToParent.isEmpty()) continue;
                List list3 = changesToParent;
                if (list3 == null) {
                    FileHistoryUtil.$$$reportNull$$$0(3);
                }
                return list3;
            }
        }
        List<Change> list4 = Collections.emptyList();
        if (list4 == null) {
            FileHistoryUtil.$$$reportNull$$$0(4);
        }
        return list4;
    }

    static boolean affectsFile(@NotNull Change change, @NotNull FilePath file2, boolean isDeleted) {
        ContentRevision revision;
        if (change == null) {
            FileHistoryUtil.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            FileHistoryUtil.$$$reportNull$$$0(6);
        }
        ContentRevision contentRevision = revision = isDeleted ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return false;
        }
        return file2.equals(revision.getFile());
    }

    public static boolean affectsDirectory(@NotNull Change change, @NotNull FilePath directory) {
        if (change == null) {
            FileHistoryUtil.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            FileHistoryUtil.$$$reportNull$$$0(8);
        }
        FilePath file2 = ((ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()))).getFile();
        return VfsUtilCore.isAncestor((File)directory.getIOFile(), (File)file2.getIOFile(), (boolean)false);
    }

    @Nullable
    static Change createChangeToParents(int commitRow, @NotNull List<Integer> parentRows, @NotNull VisiblePack visiblePack, @NotNull VcsLogDiffHandler diffHandler, @NotNull VcsLogData logData) {
        int commitIndex;
        FilePath path;
        if (parentRows == null) {
            FileHistoryUtil.$$$reportNull$$$0(9);
        }
        if (visiblePack == null) {
            FileHistoryUtil.$$$reportNull$$$0(10);
        }
        if (diffHandler == null) {
            FileHistoryUtil.$$$reportNull$$$0(11);
        }
        if (logData == null) {
            FileHistoryUtil.$$$reportNull$$$0(12);
        }
        if ((path = FileHistoryVisiblePack.filePath(visiblePack, commitIndex = ((Integer)visiblePack.getVisibleGraph().getRowInfo(commitRow).getCommit()).intValue())) == null) {
            return null;
        }
        Hash commitHash = logData.getCommitId(commitIndex).getHash();
        ContentRevision afterRevision = FileHistoryUtil.createContentRevision(commitHash, commitIndex, visiblePack, diffHandler);
        List<Object> parentCommits = ContainerUtil.map(parentRows, r -> {
            if (visiblePack == null) {
                FileHistoryUtil.$$$reportNull$$$0(19);
            }
            return (Integer)visiblePack.getVisibleGraph().getRowInfo(r.intValue()).getCommit();
        });
        if (parentCommits.isEmpty() && commitRow + 1 < visiblePack.getVisibleGraph().getVisibleCommitCount()) {
            parentCommits = Collections.singletonList(visiblePack.getVisibleGraph().getRowInfo(commitRow + 1).getCommit());
        }
        if (parentCommits.isEmpty()) {
            if (afterRevision == null) {
                return null;
            }
            return new Change(null, afterRevision);
        }
        List parentHashes = ContainerUtil.map((Collection)parentCommits, c -> {
            if (logData == null) {
                FileHistoryUtil.$$$reportNull$$$0(18);
            }
            return logData.getCommitId((int)c).getHash();
        });
        List parentChanges = ContainerUtil.mapNotNull((Collection)ContainerUtil.toCollection((Iterable)ContainerUtil.zip((Iterable)parentCommits, (Iterable)parentHashes)), parent -> {
            if (visiblePack == null) {
                FileHistoryUtil.$$$reportNull$$$0(16);
            }
            if (diffHandler == null) {
                FileHistoryUtil.$$$reportNull$$$0(17);
            }
            ContentRevision beforeRevision = FileHistoryUtil.createContentRevision((Hash)parent.second, (Integer)parent.first, visiblePack, diffHandler);
            if (afterRevision == null && beforeRevision == null) {
                return null;
            }
            return new Change(beforeRevision, afterRevision);
        });
        if (parentChanges.size() <= 1) {
            return (Change)ContainerUtil.getFirstItem((List)parentChanges);
        }
        return new MyVcsChangesMerger(commitHash, parentHashes, diffHandler).merge(path, parentChanges);
    }

    @Nullable
    private static ContentRevision createContentRevision(@NotNull Hash commitHash, int commitIndex, @NotNull VcsLogDataPack visiblePack, @NotNull VcsLogDiffHandler diffHandler) {
        boolean isDeleted;
        if (commitHash == null) {
            FileHistoryUtil.$$$reportNull$$$0(13);
        }
        if (visiblePack == null) {
            FileHistoryUtil.$$$reportNull$$$0(14);
        }
        if (diffHandler == null) {
            FileHistoryUtil.$$$reportNull$$$0(15);
        }
        if (isDeleted = FileHistoryVisiblePack.isDeletedInCommit(visiblePack, commitIndex)) {
            return null;
        }
        FilePath path = FileHistoryVisiblePack.filePath(visiblePack, commitIndex);
        if (path == null) {
            return null;
        }
        return diffHandler.createContentRevision(path, commitHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isRelevant";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRows";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffHandler";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelevantChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectRelevantChanges";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "affectsFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "affectsDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChangeToParents";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createContentRevision";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createChangeToParents$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createChangeToParents$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createChangeToParents$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVcsChangesMerger
    extends VcsChangesMerger {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final Hash myFirstParent;
        @NotNull
        private final VcsLogDiffHandler myDiffHandler;

        private MyVcsChangesMerger(@NotNull Hash commit, @NotNull List<Hash> parentCommits, @NotNull VcsLogDiffHandler diffHandler) {
            if (commit == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(0);
            }
            if (parentCommits == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(1);
            }
            if (diffHandler == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(2);
            }
            this.myCommit = commit;
            this.myFirstParent = (Hash)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(parentCommits));
            this.myDiffHandler = diffHandler;
        }

        @Override
        @NotNull
        protected Change createChange(@NotNull Change.Type type, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            if (type == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(3);
            }
            ContentRevision beforeRevision = beforePath == null ? null : this.myDiffHandler.createContentRevision(beforePath, this.myFirstParent);
            ContentRevision afterRevision = afterPath == null ? null : this.myDiffHandler.createContentRevision(afterPath, this.myCommit);
            Change change = new Change(beforeRevision, afterRevision);
            if (change == null) {
                MyVcsChangesMerger.$$$reportNull$$$0(4);
            }
            return change;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentCommits";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUtil$MyVcsChangesMerger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUtil$MyVcsChangesMerger";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createChange";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

