/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import org.jetbrains.annotations.NotNull;

@State(name="VagrantSettings", storages={@Storage(value="vagrant.xml")})
public class VagrantSettings
implements PersistentStateComponent<VagrantSettings> {
    private String myVagrantPath = VagrantSettings.detectVagrantExecutable();
    private boolean myVagrantPathMigrated = false;

    private static String detectVagrantExecutable() {
        return "vagrant";
    }

    public VagrantSettings getState() {
        return this;
    }

    public void loadState(@NotNull VagrantSettings state) {
        if (state == null) {
            VagrantSettings.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)state.getVagrantExecutable())) {
            this.setVagrantExecutable(state.getVagrantExecutable());
        }
    }

    @NotNull
    public static VagrantSettings getInstance() {
        VagrantSettings vagrantSettings = (VagrantSettings)ServiceManager.getService(VagrantSettings.class);
        if (vagrantSettings == null) {
            VagrantSettings.$$$reportNull$$$0(1);
        }
        return vagrantSettings;
    }

    @NotNull
    public String getVagrantExecutable() {
        String fallback;
        if (!this.myVagrantPathMigrated && !StringUtil.isEmpty((String)(fallback = VagrantProjectSettings.getVagrantExecutableFallback()))) {
            String string = fallback;
            if (string == null) {
                VagrantSettings.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.myVagrantPath;
        if (string == null) {
            VagrantSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setVagrantExecutable(@NotNull String vagrantPath) {
        if (vagrantPath == null) {
            VagrantSettings.$$$reportNull$$$0(4);
        }
        this.myVagrantPath = vagrantPath;
        this.myVagrantPathMigrated = true;
    }

    public String toString() {
        return "path: " + this.myVagrantPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setVagrantExecutable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

