/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.util.Getter;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class PortableStatus
extends Status {
    private boolean myConflicted;
    private Getter<Info> myInfoGetter;
    private Info myInfo;
    private String myPath;
    private boolean myFileExists;

    public PortableStatus(Url url, File file, @NotNull NodeKind kind, Revision revision, Revision committedRevision, Date committedDate, String author, StatusType contentsStatus, StatusType propertiesStatus, StatusType remoteContentsStatus, StatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, boolean isFileExternal, @Nullable Lock remoteLock, @Nullable Lock localLock, Map entryProperties, String changelistName, int wcFormatVersion, boolean isConflicted, Getter<Info> infoGetter) {
        if (kind == null) {
            PortableStatus.$$$reportNull$$$0(0);
        }
        super(url, file, kind, revision, committedRevision, contentsStatus, propertiesStatus, remoteContentsStatus, remotePropertiesStatus, isLocked, isCopied, isSwitched, null, remoteLock, localLock, changelistName, null);
        this.myConflicted = isConflicted;
        this.myInfoGetter = infoGetter == null ? () -> null : infoGetter;
    }

    public PortableStatus() {
        this.myInfoGetter = () -> null;
        this.setCommittedRevision(Revision.UNDEFINED);
    }

    @Override
    public void setIsConflicted(boolean isConflicted) {
        this.myConflicted = isConflicted;
        super.setIsConflicted(isConflicted);
    }

    public void setInfoGetter(Getter<Info> infoGetter) {
        this.myInfoGetter = infoGetter;
    }

    @Override
    public boolean isConflicted() {
        return this.myConflicted;
    }

    private Info initInfo() {
        if (this.myInfo == null) {
            StatusType contentsStatus = this.getContentsStatus();
            if (contentsStatus == null || StatusType.UNKNOWN.equals((Object)contentsStatus)) {
                return null;
            }
            this.myInfo = (Info)this.myInfoGetter.get();
        }
        return this.myInfo;
    }

    public Info getInfo() {
        return this.initInfo();
    }

    @Override
    @NotNull
    public NodeKind getKind() {
        if (this.myFileExists) {
            NodeKind nodeKind = super.getKind();
            if (nodeKind == null) {
                PortableStatus.$$$reportNull$$$0(1);
            }
            return nodeKind;
        }
        Info info = this.initInfo();
        if (info != null) {
            NodeKind nodeKind = info.getKind();
            if (nodeKind == null) {
                PortableStatus.$$$reportNull$$$0(2);
            }
            return nodeKind;
        }
        NodeKind nodeKind = super.getKind();
        if (nodeKind == null) {
            PortableStatus.$$$reportNull$$$0(3);
        }
        return nodeKind;
    }

    @Override
    public Url getCopyFromURL() {
        if (!this.isCopied()) {
            return null;
        }
        Info info = this.initInfo();
        if (info == null) {
            return null;
        }
        return this.initInfo().getCopyFromURL();
    }

    @Override
    public Url getURL() {
        Url url = super.getURL();
        if (url == null) {
            Info info = this.initInfo();
            url = info != null ? info.getURL() : url;
        }
        return url;
    }

    @Override
    public Url getRepositoryRootURL() {
        Url url = super.getRepositoryRootURL();
        if (url == null) {
            Info info = this.initInfo();
            url = info != null ? info.getRepositoryRootURL() : url;
        }
        return url;
    }

    @Override
    public File getFile() {
        File file = super.getFile();
        if (file == null) {
            Info info = this.initInfo();
            file = info != null ? info.getFile() : file;
        }
        return file;
    }

    @Override
    @NotNull
    public Revision getRevision() {
        Revision revision = super.getRevision();
        if (revision.isValid()) {
            Revision revision2 = revision;
            if (revision2 == null) {
                PortableStatus.$$$reportNull$$$0(4);
            }
            return revision2;
        }
        StatusType status = this.getContentsStatus();
        if (StatusType.STATUS_NONE.equals((Object)status) || StatusType.STATUS_UNVERSIONED.equals((Object)status) || StatusType.STATUS_ADDED.equals((Object)status)) {
            Revision revision3 = revision;
            if (revision3 == null) {
                PortableStatus.$$$reportNull$$$0(5);
            }
            return revision3;
        }
        Info info = this.initInfo();
        Revision revision4 = info == null ? revision : info.getRevision();
        if (revision4 == null) {
            PortableStatus.$$$reportNull$$$0(6);
        }
        return revision4;
    }

    @Override
    @Nullable
    public TreeConflictDescription getTreeConflict() {
        if (!this.isConflicted()) {
            return null;
        }
        Info info = this.initInfo();
        return info == null ? null : info.getTreeConflict();
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setKind(boolean exists, @NotNull NodeKind kind) {
        if (kind == null) {
            PortableStatus.$$$reportNull$$$0(7);
        }
        this.myFileExists = exists;
        this.setKind(kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/status/PortableStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/status/PortableStatus";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

