/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.loader;

import com.yourkit.util.Asserts;
import com.yourkit.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppVersion {
    public static final AppVersion CURRENT = new AppVersion("2017.02.66");
    private static final int ELEMENT_COUNT = 3;
    private final String myOriginal;
    private final int[] myParsed;

    public static boolean isRunningFromSources() {
        return !CURRENT.isValid();
    }

    @NotNull
    public static String getCurrentAsString() {
        String string = CURRENT.isValid() ? CURRENT.asString() : "running_from_sources";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public AppVersion(@NotNull String versionAs3Numbers) {
        if (versionAs3Numbers == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOriginal = versionAs3Numbers;
        this.myParsed = AppVersion.parseVersionAsNumbers(versionAs3Numbers);
    }

    public boolean isValid() {
        return this.myParsed != null;
    }

    public int compareTo(@NotNull AppVersion other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!this.isValid()) {
            Asserts.fail();
        }
        if (!other.isValid()) {
            Asserts.fail();
        }
        for (int i = 0; i < this.myParsed.length; ++i) {
            int v1 = this.myParsed[i];
            int v2 = other.myParsed[i];
            if (v1 == v2) continue;
            return Util.compare(v1, v2);
        }
        return 0;
    }

    @NotNull
    public String asString() {
        String string = this.myOriginal;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    private static int[] parseVersionAsNumbers(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String[] elements = versionStr.split("\\.");
        if (elements.length != 3) {
            return null;
        }
        int[] result = new int[3];
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            try {
                result[i] = Integer.parseInt(element);
                continue;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return result;
    }

    public String getYearDotMonth() {
        int month = this.myParsed[1];
        return this.myParsed[0] + "." + (month < 10 ? "0" : "") + month;
    }
}

