/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.StartButtonHandler;

public class ZoomPrintPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ZoomPrintPanel.class);
    static final int ZOOM_MIN_PERCENT = 10;
    static final int ZOOM_MAX_PERCENT = 400;
    static final int EDGES_MIN_PERCENT = 10;
    static final int EDGES_MAX_PERCENT = 150;
    JSlider sldZoom;
    JCheckBox chkHideScrollBars;
    JComboBox cboFormat;
    JButton btnFormat;
    JSlider sldEdges;
    JCheckBox chkShowEdges;
    JButton btnPrint;
    JButton btnSaveImages;

    public ZoomPrintPanel(GraphPluginResources rsrc, StartButtonHandler startButtonHandler) {
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)startButtonHandler.getButton(), "West");
        this.add((Component)this.createZoomPrintPanel(rsrc), "Center");
    }

    private JPanel createZoomPrintPanel(GraphPluginResources rsrc) {
        JPanel ret = new JPanel(new GridLayout(1, 2, 20, 0));
        ret.add(this.createZoomPanel());
        ret.add(this.createPrintPanel(rsrc));
        return ret;
    }

    private JPanel createPrintPanel(GraphPluginResources rsrc) {
        JPanel ret = new JPanel(new BorderLayout());
        JPanel pnlLeft = new JPanel(new BorderLayout());
        this.chkShowEdges = new JCheckBox(s_stringMgr.getString("graph.showZoomPaper"));
        pnlLeft.add((Component)this.chkShowEdges, "West");
        JPanel pnlFormat = new JPanel(new BorderLayout());
        this.btnFormat = new JButton(s_stringMgr.getString("graph.format"));
        pnlFormat.add((Component)this.btnFormat, "West");
        this.cboFormat = new JComboBox();
        pnlFormat.add((Component)this.cboFormat, "Center");
        pnlLeft.add((Component)pnlFormat, "Center");
        ret.add((Component)pnlLeft, "West");
        this.sldEdges = new JSlider(0, 10, 150, 100);
        ret.add((Component)this.sldEdges, "Center");
        this.btnPrint = new JButton(rsrc.getIcon("Print"));
        Dimension printBtnPrefSize = this.btnPrint.getPreferredSize();
        this.btnPrint.setPreferredSize(printBtnPrefSize);
        this.btnPrint.setToolTipText(s_stringMgr.getString("graph.printGraph"));
        this.btnSaveImages = new JButton(rsrc.getIcon("SaveImagesToFile"));
        Dimension btnCopyToClipPrefSize = this.btnPrint.getPreferredSize();
        this.btnSaveImages.setPreferredSize(btnCopyToClipPrefSize);
        this.btnSaveImages.setToolTipText(s_stringMgr.getString("graph.saveGraphImagesToFile"));
        JPanel pnlButtons = new JPanel(new GridLayout(1, 2));
        pnlButtons.add(this.btnSaveImages);
        pnlButtons.add(this.btnPrint);
        ret.add((Component)pnlButtons, "East");
        return ret;
    }

    private JPanel createZoomPanel() {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)new JLabel(s_stringMgr.getString("graph.zoom")), "West");
        this.sldZoom = new JSlider(0, 10, 400, 100);
        ret.add((Component)this.sldZoom, "Center");
        this.chkHideScrollBars = new JCheckBox(s_stringMgr.getString("graph.hideScrollBars"));
        ret.add((Component)this.chkHideScrollBars, "East");
        return ret;
    }
}

