/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class SQLQueryImpl
extends AbstractQueryImpl
implements SQLQuery {
    private final List queryReturns;
    private Collection querySpaces;
    private final boolean callable;
    private boolean autodiscovertypes;
    private static final NativeSQLQueryReturn[] NO_SQL_RETURNS = new NativeSQLQueryReturn[0];

    SQLQueryImpl(NamedSQLQueryDefinition queryDef, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(queryDef.getQueryString(), queryDef.getFlushMode(), session, parameterMetadata);
        if (queryDef.getResultSetRef() != null) {
            ResultSetMappingDefinition definition = session.getFactory().getResultSetMapping(queryDef.getResultSetRef());
            if (definition == null) {
                throw new MappingException("Unable to find resultset-ref definition: " + queryDef.getResultSetRef());
            }
            this.queryReturns = Arrays.asList(definition.getQueryReturns());
        } else {
            this.queryReturns = Arrays.asList(queryDef.getQueryReturns());
        }
        this.querySpaces = queryDef.getQuerySpaces();
        this.callable = queryDef.isCallable();
    }

    SQLQueryImpl(String sql, List queryReturns, Collection querySpaces, FlushMode flushMode, boolean callable, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(sql, flushMode, session, parameterMetadata);
        this.queryReturns = queryReturns;
        this.querySpaces = querySpaces;
        this.callable = callable;
    }

    SQLQueryImpl(String sql, String[] returnAliases, Class[] returnClasses, LockMode[] lockModes, SessionImplementor session, Collection querySpaces, FlushMode flushMode, ParameterMetadata parameterMetadata) {
        super(sql, flushMode, session, parameterMetadata);
        this.queryReturns = new ArrayList(returnAliases.length);
        for (int i = 0; i < returnAliases.length; ++i) {
            NativeSQLQueryRootReturn ret = new NativeSQLQueryRootReturn(returnAliases[i], returnClasses[i].getName(), lockModes == null ? LockMode.NONE : lockModes[i]);
            this.queryReturns.add(ret);
        }
        this.querySpaces = querySpaces;
        this.callable = false;
    }

    SQLQueryImpl(String sql, String[] returnAliases, Class[] returnClasses, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this(sql, returnAliases, returnClasses, null, session, null, null, parameterMetadata);
    }

    SQLQueryImpl(String sql, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(sql, null, session, parameterMetadata);
        this.queryReturns = new ArrayList();
        this.querySpaces = null;
        this.callable = false;
    }

    private NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns.toArray(NO_SQL_RETURNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.verifyParameters();
        this.before();
        Map namedParams = this.getNamedParams();
        NativeSQLQuerySpecification spec = this.generateQuerySpecification(namedParams);
        try {
            List list = this.getSession().list(spec, this.getQueryParameters(namedParams));
            return list;
        }
        finally {
            this.after();
        }
    }

    private NativeSQLQuerySpecification generateQuerySpecification(Map namedParams) {
        return new NativeSQLQuerySpecification(this.expandParameterLists(namedParams), this.getQueryReturns(), this.querySpaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        this.before();
        Map namedParams = this.getNamedParams();
        NativeSQLQuerySpecification spec = this.generateQuerySpecification(namedParams);
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(spec, qp);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    public QueryParameters getQueryParameters(Map namedParams) {
        QueryParameters qp = super.getQueryParameters(namedParams);
        qp.setCallable(this.callable);
        qp.setAutoDiscoverScalarTypes(this.autodiscovertypes);
        return qp;
    }

    protected void verifyParameters() {
        boolean noReturns;
        this.verifyParameters(this.callable);
        boolean bl = noReturns = this.queryReturns == null || this.queryReturns.isEmpty();
        if (noReturns) {
            this.autodiscovertypes = noReturns;
        } else {
            Iterator itr = this.queryReturns.iterator();
            while (itr.hasNext()) {
                NativeSQLQueryScalarReturn scalar;
                NativeSQLQueryReturn rtn = (NativeSQLQueryReturn)itr.next();
                if (!(rtn instanceof NativeSQLQueryScalarReturn) || (scalar = (NativeSQLQueryScalarReturn)rtn).getType() != null) continue;
                this.autodiscovertypes = true;
                break;
            }
        }
    }

    public String[] getReturnAliases() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support returning aliases");
    }

    public Type[] getReturnTypes() throws HibernateException {
        throw new UnsupportedOperationException("not yet implemented for SQL queries");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("cannot set the lock mode for a native SQL query");
    }

    protected Map getLockModes() {
        return CollectionHelper.EMPTY_MAP;
    }

    public SQLQuery addScalar(String columnAlias, Type type) {
        this.queryReturns.add(new NativeSQLQueryScalarReturn(columnAlias, type));
        return this;
    }

    public SQLQuery addScalar(String columnAlias) {
        this.autodiscovertypes = true;
        this.queryReturns.add(new NativeSQLQueryScalarReturn(columnAlias, null));
        return this;
    }

    public SQLQuery addJoin(String alias, String path) {
        return this.addJoin(alias, path, LockMode.READ);
    }

    public SQLQuery addEntity(Class entityClass) {
        return this.addEntity(StringHelper.unqualify(entityClass.getName()), entityClass);
    }

    public SQLQuery addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    public SQLQuery addEntity(String alias, String entityName) {
        return this.addEntity(alias, entityName, LockMode.READ);
    }

    public SQLQuery addEntity(String alias, Class entityClass) {
        return this.addEntity(alias, entityClass.getName());
    }

    public SQLQuery addJoin(String alias, String path, LockMode lockMode) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException("not a property path: " + path);
        }
        String ownerAlias = path.substring(0, loc);
        String role = path.substring(loc + 1);
        this.queryReturns.add(new NativeSQLQueryJoinReturn(alias, ownerAlias, role, CollectionHelper.EMPTY_MAP, lockMode));
        return this;
    }

    public SQLQuery addEntity(String alias, String entityName, LockMode lockMode) {
        this.queryReturns.add(new NativeSQLQueryRootReturn(alias, entityName, lockMode));
        return this;
    }

    public SQLQuery addEntity(String alias, Class entityClass, LockMode lockMode) {
        return this.addEntity(alias, entityClass.getName(), lockMode);
    }

    public SQLQuery setResultSetMapping(String name) {
        ResultSetMappingDefinition mapping = this.session.getFactory().getResultSetMapping(name);
        if (mapping == null) {
            throw new MappingException("Unknown SqlResultSetMapping [" + name + "]");
        }
        NativeSQLQueryReturn[] returns = mapping.getQueryReturns();
        int length = returns.length;
        for (int index = 0; index < length; ++index) {
            this.queryReturns.add(returns[index]);
        }
        return this;
    }

    public SQLQuery addSynchronizedQuerySpace(String querySpace) {
        if (this.querySpaces == null) {
            this.querySpaces = new ArrayList();
        }
        this.querySpaces.add(querySpace);
        return this;
    }

    public SQLQuery addSynchronizedEntityName(String entityName) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(entityName).getQuerySpaces());
    }

    public SQLQuery addSynchronizedEntityClass(Class entityClass) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(entityClass.getName()).getQuerySpaces());
    }

    private SQLQuery addQuerySpaces(Serializable[] spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new ArrayList();
            }
            for (int i = 0; i < spaces.length; ++i) {
                this.querySpaces.add(spaces[i]);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws HibernateException {
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeNativeUpdate(this.generateQuerySpecification(namedParams), this.getQueryParameters(namedParams));
            return n;
        }
        finally {
            this.after();
        }
    }
}

