/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.CharRange;

public class StringCalculator
implements Calculator<String> {
    private CharRange _charRange;

    public StringCalculator(CharRange charRange) {
        this._charRange = charRange;
    }

    @Override
    public String getMid(String min, String max) {
        String dist = this.getDist(min, max);
        String halfDist = this.getHalf(dist);
        String ret = this.add(min, halfDist);
        return ret;
    }

    private String add(String min, String halfDist) {
        StringBuffer bufHalfDist = new StringBuffer(halfDist);
        int len = bufHalfDist.length();
        StringBuffer bufRet = null == min ? new StringBuffer() : new StringBuffer(min);
        this.minCharUpToLen(bufRet, len);
        bufRet.reverse();
        bufHalfDist.reverse();
        boolean einsImSinn = false;
        for (int i = 0; i < len; ++i) {
            char sumChar = (char)(bufRet.charAt(i) + bufHalfDist.charAt(i));
            if (einsImSinn) {
                sumChar = (char)(sumChar + '\u0001');
                einsImSinn = false;
            }
            if (sumChar > this._charRange.getMaxChar()) {
                einsImSinn = true;
                sumChar = (char)(sumChar - this._charRange.getRange());
            }
            bufRet.setCharAt(i, sumChar);
        }
        return bufRet.reverse().toString();
    }

    private String getHalf(String dist) {
        StringBuffer bufDist = new StringBuffer(dist);
        StringBuffer bufHalfDist = new StringBuffer(bufDist.length());
        for (int i = 0; i < bufDist.length(); ++i) {
            char c = bufDist.charAt(i);
            bufHalfDist.append((char)(c / 2));
            if (1 != c % 2 || i + 1 >= bufDist.length()) continue;
            bufDist.setCharAt(i + 1, (char)(bufDist.charAt(i + 1) + this._charRange.getRange()));
        }
        return bufHalfDist.toString();
    }

    private String getDist(String min, String max) {
        int len = Math.max(this.getLen(min), this.getLen(max));
        StringBuffer bufMin = new StringBuffer();
        StringBuffer bufMax = new StringBuffer();
        if (null != min) {
            bufMin.append(min);
        }
        if (null != max) {
            bufMax.append(max);
        }
        this.minCharUpToLen(bufMin, len);
        this.minCharUpToLen(bufMax, len);
        bufMin.reverse();
        bufMax.reverse();
        StringBuffer bufDist = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char cMin;
            char cMax = bufMax.charAt(i);
            if (cMax >= (cMin = bufMin.charAt(i))) {
                bufDist.append((char)(cMax - cMin));
                continue;
            }
            bufDist.append((char)(cMax + this._charRange.getRange() - cMin));
            bufMin.setCharAt(i + 1, (char)(bufMin.charAt(i + 1) + '\u0001'));
        }
        return bufDist.reverse().toString();
    }

    private int getLen(String s) {
        if (null == s) {
            return 0;
        }
        return s.length();
    }

    private void minCharUpToLen(StringBuffer toInit, int len) {
        for (int i = toInit.length(); i < len; ++i) {
            toInit.append(this._charRange.getMinChar());
        }
    }
}

