/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;

public abstract class AbstractRefactoringAction
extends SquirrelAction
implements IObjectTreeAction {
    protected ISession _session;
    protected IObjectTreeAPI _tree;

    public AbstractRefactoringAction(IApplication app, Resources rsrc) {
        super(app, (IResources)rsrc);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            IDatabaseObjectInfo[] infos = this._tree.getSelectedDatabaseObjects();
            if (infos.length > 1 && !this.isMultipleObjectAction()) {
                this._session.showErrorMessage(this.getErrorMessage());
            } else {
                try {
                    this.getCommand(infos).execute();
                }
                catch (Exception e) {
                    this._session.showErrorMessage((Throwable)e);
                }
            }
        }
    }

    protected abstract ICommand getCommand(IDatabaseObjectInfo[] var1);

    protected abstract boolean isMultipleObjectAction();

    protected abstract String getErrorMessage();

    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this._session = null != this._tree ? this._tree.getSession() : null;
        this.setEnabled(null != this._tree);
    }
}

