/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class WebkitGDBus {
    private static final String WEBKITGDBUS_DBUS_NAME = "org.eclipse.swt";
    private static final byte[] WEBKITGDBUS_OBJECT_PATH = Converter.javaStringToCString("/org/eclipse/swt/gdbus");
    private static final String WEBKITGDBUS_INTERFACE_NAME_JAVA = "org.eclipse.swt.gdbusInterface";
    private static final byte[] WEBKITGDBUS_INTERFACE_NAME = Converter.javaStringToCString("org.eclipse.swt.gdbusInterface");
    private static final byte[] EXTENSION_DBUS_NAME = Converter.javaStringToCString("org.eclipse.swt.webkitgtk_extension");
    private static final byte[] EXTENSION_OBJECT_PATH = Converter.javaStringToCString("/org/eclipse/swt/webkitgtk_extension/gdbus");
    private static final byte[] EXTENSION_INTERFACE_NAME = Converter.javaStringToCString("org.eclipse.swt.webkitgtk_extension.gdbusInterface");
    private static String EXTENSION_DBUS_SERVER_CLIENT_ADDRESS;
    private static final String webkit2callJava;
    private static final String webkitWebExtensionIdentifier;
    static long connectionFromExtension;
    static long connectionToExtension;
    static boolean connectionToExtensionCreated;
    private static long gDBusServer;
    private static long authObserver;
    private static long guid;
    static Display display;
    static boolean functionsPending;
    static HashMap<Long, ArrayList<ArrayList<String>>> pendingBrowserFunctions;
    private static final byte[] WEBKITGDBUS_INTROSPECTION_XML;
    private static final byte SWT_DBUS_MAGIC_NUMBER_EMPTY_ARRAY = 101;
    private static final byte SWT_DBUS_MAGIC_NUMBER_NULL = 48;
    private static Callback handleMethodCB;
    private static Callback newConnectionCB;
    private static Callback newConnectionToExtensionCB;
    private static Callback authenticatePeerCB;
    private static Callback callExtensionAsyncCB;
    static boolean initialized;
    static boolean attachedToDisplay;

    WebkitGDBus() {
    }

    static long init() {
        long[] error;
        if (initialized) {
            return gDBusServer;
        }
        initialized = true;
        long address = WebkitGDBus.construct_server_address();
        authObserver = OS.g_dbus_auth_observer_new();
        guid = OS.g_dbus_generate_guid();
        gDBusServer = OS.g_dbus_server_new_sync(address, 0, guid, authObserver, 0L, error = new long[1]);
        if (gDBusServer != 0L) {
            OS.g_signal_connect(gDBusServer, OS.new_connection, newConnectionCB.getAddress(), 0L);
            OS.g_signal_connect(authObserver, OS.authorize_authenticated_peer, authenticatePeerCB.getAddress(), 0L);
            OS.g_dbus_server_start(gDBusServer);
        } else {
            System.err.println("SWT WebKitGDBus: error creating DBus server " + Display.extractFreeGError(error[0]));
        }
        return gDBusServer;
    }

    static void setDisplay(Display displayToSet) {
        if (attachedToDisplay) {
            return;
        }
        display = displayToSet;
        if (gDBusServer != 0L) {
            WebkitGDBus.display.dBusServers.add(gDBusServer);
        }
        if (authObserver != 0L) {
            WebkitGDBus.display.dBusAuthObservers.add(authObserver);
        }
        if (guid != 0L) {
            WebkitGDBus.display.dBusGUIDS.add(guid);
        }
        attachedToDisplay = true;
    }

    private static long construct_server_address() {
        byte[] address = Converter.wcsToMbcs("unix:tmpdir=/tmp/SWT-GDBusServer", true);
        long addressPtr = OS.g_malloc(address.length);
        C.memmove(addressPtr, address, (long)address.length);
        return addressPtr;
    }

    private static long handleMethodCB(long connection, long sender, long object_path, long interface_name, long method_name, long gvar_parameters, long invocation, long user_data) {
        String java_method_name = Converter.cCharPtrToJavaString(method_name, false);
        Object result = null;
        if (java_method_name != null) {
            if (java_method_name.equals(webkit2callJava)) {
                try {
                    Object[] java_parameters = (Object[])WebkitGDBus.convertGVariantToJava(gvar_parameters);
                    result = WebKit.WebKitExtension.webkit2callJavaCallback(java_parameters);
                }
                catch (Exception e) {
                    result = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    System.err.println("SWT WebkitGDBus: Exception occured in Webkit2 callback logic.");
                }
            } else if (java_method_name.equals(webkitWebExtensionIdentifier)) {
                Object[] serverAddress = (Object[])WebkitGDBus.convertGVariantToJava(gvar_parameters);
                if (serverAddress[0] != null && serverAddress[0] instanceof String) {
                    EXTENSION_DBUS_SERVER_CLIENT_ADDRESS = (String)serverAddress[0];
                    WebkitGDBus.createConnectionToExtension();
                    WebkitGDBus.invokeReturnValueExtensionIdentifier(pendingBrowserFunctions, invocation);
                } else {
                    System.err.println("SWT WebkitGDBus: error in web extension identification process. BrowserFunction may not work.");
                }
                return 0L;
            }
        } else {
            result = "SWT WebkitGDBus: GDBus called an unknown method?";
            System.err.println("SWT WebkitGDBus: Received a call from an unknown method: " + java_method_name);
        }
        WebkitGDBus.invokeReturnValue(result, invocation);
        return 0L;
    }

    private static long callExtensionAsyncCB(long source_object, long result, long user_data) {
        long[] error = new long[1];
        long gVariantResult = OS.g_dbus_connection_call_finish(connectionToExtension, result, error);
        if (error[0] != 0L) {
            String msg = Display.extractFreeGError(error[0]);
            System.err.println("SWT WebkitGDBus: there was an error executing something asynchronously with the extension (Java callback).");
            System.err.println("SWT WebkitGDBus: the error message provided is " + msg);
        }
        OS.g_variant_unref(gVariantResult);
        return 0L;
    }

    private static long authenticatePeerCB(long observer, long stream, long credentials, long user_data) {
        boolean authorized = false;
        if (credentials != 0L) {
            long[] error = new long[1];
            long ownCredentials = OS.g_credentials_new();
            authorized = OS.g_credentials_is_same_user(credentials, ownCredentials, error);
            if (error[0] != 0L) {
                String msg = Display.extractFreeGError(error[0]);
                System.err.println("SWT WebkitGDBus: error authenticating client connection to server " + msg);
            }
            OS.g_object_unref(ownCredentials);
        }
        return authorized ? 1L : 0L;
    }

    private static long newConnectionCB(long server, long connection, long user_data) {
        long[] error = new long[1];
        long gdBusNodeInfo = OS.g_dbus_node_info_new_for_xml(WEBKITGDBUS_INTROSPECTION_XML, error);
        if (gdBusNodeInfo == 0L || error[0] != 0L) {
            System.err.println("SWT WebkitGDBus: failed to get introspection data");
        }
        assert (gdBusNodeInfo != 0L) : "SWT WebKitGDBus: introspection data should not be 0";
        long interface_info = OS.g_dbus_node_info_lookup_interface(gdBusNodeInfo, WEBKITGDBUS_INTERFACE_NAME);
        long[] vtable = new long[]{handleMethodCB.getAddress(), 0L, 0L};
        OS.g_dbus_connection_register_object(connection, WEBKITGDBUS_OBJECT_PATH, interface_info, vtable, 0L, 0L, error);
        if (error[0] != 0L) {
            System.err.println("SWT WebKitGDBus: failed to register object: " + WEBKITGDBUS_OBJECT_PATH);
            return 0L;
        }
        connectionFromExtension = OS.g_object_ref(connection);
        if (attachedToDisplay && display != null && !WebkitGDBus.display.dBusConnections.contains(connection)) {
            WebkitGDBus.display.dBusConnections.add(connectionFromExtension);
        }
        return 1L;
    }

    private static long newConnectionToExtensionCB(long sourceObject, long result, long user_data) {
        long[] error = new long[1];
        connectionToExtension = OS.g_dbus_connection_new_for_address_finish(result, error);
        if (error[0] != 0L) {
            System.err.println("SWT WebKitGDBus: error finishing connection: " + Display.extractFreeGError(error[0]));
            return 0L;
        }
        connectionToExtensionCreated = true;
        if (attachedToDisplay && display != null && !WebkitGDBus.display.dBusConnections.contains(connectionToExtension)) {
            WebkitGDBus.display.dBusConnections.add(connectionToExtension);
        }
        return 0L;
    }

    private static void invokeReturnValueExtensionIdentifier(HashMap<Long, ArrayList<ArrayList<String>>> map, long invocation) {
        boolean sendEmptyFunction;
        long type = OS.g_variant_type_new(OS.G_VARIANT_TYPE_ARRAY_BROWSER_FUNCS);
        long builder = OS.g_variant_builder_new(type);
        if (builder == 0L) {
            return;
        }
        Object[] tupleArray = new Object[3];
        if (map == null) {
            sendEmptyFunction = true;
        } else {
            boolean bl = sendEmptyFunction = map.isEmpty() && !functionsPending;
        }
        if (sendEmptyFunction) {
            tupleArray[0] = -1L;
            tupleArray[1] = "";
            tupleArray[2] = "";
            long tupleGVariant = WebkitGDBus.convertJavaToGVariant(tupleArray);
            if (tupleGVariant != 0L) {
                OS.g_variant_builder_add_value(builder, tupleGVariant);
            } else {
                System.err.println("SWT WebKitGDBus: error creating empty BrowserFunction GVariant tuple, skipping.");
            }
        } else {
            for (long id : map.keySet()) {
                ArrayList<ArrayList<String>> list = map.get(id);
                if (list == null) continue;
                for (ArrayList<String> stringList : list) {
                    Object[] stringArray = stringList.toArray();
                    if (stringArray.length > 2) {
                        System.err.println("SWT WebKitGDBus: String array with BrowserFunction and URL should never havemore than 2 Strings");
                    }
                    tupleArray[0] = id;
                    System.arraycopy(stringArray, 0, tupleArray, 1, 2);
                    long tupleGVariant = WebkitGDBus.convertJavaToGVariant(tupleArray);
                    if (tupleGVariant != 0L) {
                        OS.g_variant_builder_add_value(builder, tupleGVariant);
                        continue;
                    }
                    System.err.println("SWT WebKitGDBus: error creating BrowserFunction GVariant tuple, skipping.");
                }
            }
        }
        long resultGVariant = OS.g_variant_builder_end(builder);
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(resultGVariant), false);
        if (!"a(tss)".equals(typeString)) {
            System.err.println("SWT WebKitGDBus: an error packaging the GVariant occurred: type mismatch.");
        }
        long[] variants = new long[]{resultGVariant};
        long finalGVariant = OS.g_variant_new_tuple(variants, 1L);
        OS.g_dbus_method_invocation_return_value(invocation, finalGVariant);
        OS.g_variant_builder_unref(builder);
        OS.g_variant_type_free(type);
    }

    private static void invokeReturnValue(Object result, long invocation) {
        long resultGVariant = 0L;
        try {
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{result});
        }
        catch (SWTException e) {
            String errMsg = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{errMsg});
        }
        OS.g_dbus_method_invocation_return_value(invocation, resultGVariant);
    }

    private static void createConnectionToExtension() {
        byte[] address = Converter.javaStringToCString(EXTENSION_DBUS_SERVER_CLIENT_ADDRESS);
        long[] error = new long[1];
        OS.g_dbus_connection_new_for_address(address, 1, 0L, 0L, newConnectionToExtensionCB.getAddress(), 0L);
        if (error[0] != 0L) {
            System.err.println("SWT WebkitGDBus: error creating connection to the extension " + Display.extractFreeGError(error[0]));
        }
    }

    static Object callExtensionSync(long params, String methodName) {
        Object resultObject;
        long[] error = new long[1];
        long gVariant = OS.g_dbus_connection_call_sync(connectionToExtension, EXTENSION_DBUS_NAME, EXTENSION_OBJECT_PATH, EXTENSION_INTERFACE_NAME, Converter.javaStringToCString(methodName), params, 0L, 1, 1000, 0L, error);
        if (error[0] != 0L) {
            String msg = Display.extractFreeGError(error[0]);
            if (msg != null && !msg.contains("Timeout") && !msg.contains("timeout")) {
                System.err.println("SWT WebKitGDBus: there was an error executing something synchronously with the extension.");
                System.err.println("SWT WebKitGDBus: the error message is: " + msg);
                return false;
            }
            return "timeout";
        }
        Object object = resultObject = gVariant != 0L ? WebkitGDBus.convertGVariantToJava(gVariant) : Boolean.valueOf(false);
        if (resultObject instanceof Object[]) {
            return ((Object[])resultObject)[0];
        }
        return resultObject;
    }

    static boolean callExtensionAsync(long params, String methodName) {
        long[] error = new long[1];
        OS.g_dbus_connection_call(connectionToExtension, EXTENSION_DBUS_NAME, EXTENSION_OBJECT_PATH, EXTENSION_INTERFACE_NAME, Converter.javaStringToCString(methodName), params, 0L, 1, 1000, 0L, callExtensionAsyncCB.getAddress(), 0L);
        if (error[0] != 0L) {
            String msg = Display.extractFreeGError(error[0]);
            System.err.println("SWT WebKitGDBus: there was an error executing something asynchronously with the extension.");
            System.err.println("SWT WebKitGDBus: the error message is: " + msg);
            return false;
        }
        return true;
    }

    static Object convertGVariantToJava(long gVariant) {
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BOOLEAN)) {
            return OS.g_variant_get_boolean(gVariant);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BYTE)) {
            byte byteVal = OS.g_variant_get_byte(gVariant);
            switch (byteVal) {
                case 48: {
                    return null;
                }
                case 101: {
                    return new Object[0];
                }
            }
            System.err.println("SWT WebKitGDBus: received an unsupported byte type via GDBus: " + byteVal);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_DOUBLE)) {
            return OS.g_variant_get_double(gVariant);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_UINT64)) {
            return OS.g_variant_get_uint64(gVariant);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_STRING)) {
            return Converter.cCharPtrToJavaString(OS.g_variant_get_string(gVariant, null), false);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_TUPLE)) {
            int length = (int)OS.g_variant_n_children(gVariant);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = WebkitGDBus.convertGVariantToJava(OS.g_variant_get_child_value(gVariant, i));
            }
            return result;
        }
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(gVariant), false);
        SWT.error(5, new Throwable("Unhandled variant type " + typeString));
        return null;
    }

    static long convertJavaToGVariant(Object javaObject) throws SWTException {
        if (javaObject == null) {
            return OS.g_variant_new_byte((byte)48);
        }
        if (javaObject instanceof Long) {
            return OS.g_variant_new_uint64((Long)javaObject);
        }
        if (javaObject instanceof String) {
            return OS.g_variant_new_string(Converter.javaStringToCString((String)javaObject));
        }
        if (javaObject instanceof Boolean) {
            return OS.g_variant_new_boolean((Boolean)javaObject);
        }
        if (javaObject instanceof Number) {
            return OS.g_variant_new_double(((Number)javaObject).doubleValue());
        }
        if (javaObject instanceof Object[]) {
            Object[] arrayValue = (Object[])javaObject;
            int length = arrayValue.length;
            if (length == 0) {
                return OS.g_variant_new_byte((byte)101);
            }
            long[] variants = new long[length];
            for (int i = 0; i < length; ++i) {
                variants[i] = WebkitGDBus.convertJavaToGVariant(arrayValue[i]);
            }
            return OS.g_variant_new_tuple(variants, length);
        }
        System.err.println("SWT WebKitGDBus: invalid object being returned to JavaScript: " + javaObject.toString() + "\nOnly the following are supported: null, String, Boolean, Number(Long,Integer,Double...), Object[] of basic types");
        throw new SWTException(5, "Given object is not valid: " + javaObject.toString());
    }

    static {
        webkit2callJava = WebKit.WebKitExtension.getJavaScriptFunctionName();
        webkitWebExtensionIdentifier = WebKit.WebKitExtension.getWebExtensionIdentifier();
        gDBusServer = 0L;
        authObserver = 0L;
        guid = 0L;
        pendingBrowserFunctions = new HashMap();
        WEBKITGDBUS_INTROSPECTION_XML = Converter.javaStringToCString("<node>  <interface name='org.eclipse.swt.gdbusInterface'>    <method name='" + webkit2callJava + "'>      <arg type='s' name='webViewPtr' direction='in'/>      <arg type='d' name='index' direction='in'/>      <arg type='s' name='token' direction='in'/>      <arg type='*' name='arguments' direction='in'/>      <arg type='*' name='result' direction='out'/>    </method>\t<method name='" + webkitWebExtensionIdentifier + "'>      <arg type='s' name='webExtensionServerAddress' direction='in'/>      <arg type='a(tss)' name='result' direction='out'/>    </method>  </interface></node>");
        handleMethodCB = new Callback(WebkitGDBus.class, "handleMethodCB", 8);
        callExtensionAsyncCB = new Callback(WebkitGDBus.class, "callExtensionAsyncCB", 3);
        newConnectionCB = new Callback(WebkitGDBus.class, "newConnectionCB", 3);
        newConnectionToExtensionCB = new Callback(WebkitGDBus.class, "newConnectionToExtensionCB", 3);
        authenticatePeerCB = new Callback(WebkitGDBus.class, "authenticatePeerCB", 4);
    }
}

