/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";
    private Iterator<String> passwords;
    private String current;

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.passwords = ClientSession.passwordIteratorOf(session);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport((SessionContext)session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest({})[{}] session is not secure", (Object)session, (Object)service);
            }
            return false;
        }
        this.current = this.resolveAttemptedPassword(session, service);
        if (this.current == null) {
            PasswordAuthenticationReporter reporter;
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveAttemptedPassword({})[{}] no more passwords to send", (Object)session, (Object)service);
            }
            if ((reporter = session.getPasswordAuthenticationReporter()) != null) {
                reporter.signalAuthenticationExhausted(session, service);
            }
            return false;
        }
        String username = session.getUsername();
        Buffer buffer = session.createBuffer((byte)50, username.length() + service.length() + GenericUtils.length((CharSequence)this.getName()) + this.current.length() + 32);
        this.sendPassword(buffer, session, this.current, this.current);
        return true;
    }

    protected String resolveAttemptedPassword(ClientSession session, String service) throws Exception {
        if (this.passwords != null && this.passwords.hasNext()) {
            return this.passwords.next();
        }
        UserInteraction ui = session.getUserInteraction();
        if (ui == null || !ui.isInteractionAllowed(session)) {
            return null;
        }
        return ui.resolveAuthPasswordAttempt(session);
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        String password;
        boolean interactive;
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName((int)cmd));
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport((SessionContext)session)) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] session is not secure", (Object)session, (Object)service);
            }
            return false;
        }
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport((SessionContext)session)) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] session is not validated via MAC", (Object)session, (Object)service);
            }
            return false;
        }
        String prompt = buffer.getString();
        String lang = buffer.getString();
        UserInteraction ui = session.getUserInteraction();
        try {
            interactive = ui != null && ui.isInteractionAllowed(session);
            password = interactive ? ui.getUpdatedPassword(session, prompt, lang) : null;
        }
        catch (Error e) {
            this.warn("processAuthDataRequest({})[{}] failed ({}) to consult interaction: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        if (interactive) {
            if (GenericUtils.isEmpty((CharSequence)password)) {
                if (debugEnabled) {
                    this.log.debug("processAuthDataRequest({})[{}] No updated password for prompt={}, lang={}", new Object[]{session, service, prompt, lang});
                }
                return false;
            }
            this.sendPassword(buffer, session, password, password);
            return true;
        }
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}] no UI for password change request for prompt={}, lang={}", new Object[]{session, service, prompt, lang});
        }
        return false;
    }

    protected IoWriteFuture sendPassword(Buffer buffer, ClientSession session, String oldPassword, String newPassword) throws Exception {
        PasswordAuthenticationReporter reporter;
        boolean modified;
        String username = session.getUsername();
        String service = this.getService();
        String name = this.getName();
        boolean bl = modified = !Objects.equals(oldPassword, newPassword);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPassword({})[{}] send SSH_MSG_USERAUTH_REQUEST for {} - modified={}", new Object[]{session, service, name, modified});
        }
        buffer = session.createBuffer((byte)50, GenericUtils.length((CharSequence)username) + GenericUtils.length((CharSequence)service) + GenericUtils.length((CharSequence)name) + GenericUtils.length((CharSequence)oldPassword) + (modified ? GenericUtils.length((CharSequence)newPassword) : 0) + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(modified);
        buffer.putString(oldPassword);
        if (modified) {
            buffer.putString(newPassword);
        }
        if ((reporter = session.getPasswordAuthenticationReporter()) != null) {
            reporter.signalAuthenticationAttempt(session, service, oldPassword, modified, newPassword);
        }
        return session.writePacket(buffer);
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session, String service, Buffer buffer) throws Exception {
        PasswordAuthenticationReporter reporter = session.getPasswordAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session, service, this.current);
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        PasswordAuthenticationReporter reporter = session.getPasswordAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationFailure(session, service, this.current, partial, serverMethods);
        }
    }
}

