/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractFunctionInvokation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConditionalExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StackSSALabel;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterFlags;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifiers;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericBaseInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;

public class IllegalGenericRewriter
implements ExpressionRewriter {
    private final ConstantPool cp;

    public IllegalGenericRewriter(ConstantPool cp) {
        this.cp = cp;
    }

    private boolean hasIllegalGenerics(JavaTypeInstance javaTypeInstance) {
        if (!(javaTypeInstance instanceof JavaGenericBaseInstance)) {
            return false;
        }
        JavaGenericBaseInstance genericBaseInstance = (JavaGenericBaseInstance)javaTypeInstance;
        return genericBaseInstance.hasForeignUnbound(this.cp);
    }

    private void maybeRewriteExpressionType(InferredJavaType inferredJavaType) {
        JavaTypeInstance javaTypeInstance = inferredJavaType.getJavaTypeInstance();
        if (this.hasIllegalGenerics(javaTypeInstance)) {
            JavaTypeInstance deGenerified = javaTypeInstance.getDeGenerifiedType();
            inferredJavaType.deGenerify(deGenerified);
        }
    }

    private void maybeRewriteExplicitCallTyping(AbstractFunctionInvokation abstractFunctionInvokation) {
        List<JavaTypeInstance> list = abstractFunctionInvokation.getExplicitGenerics();
        if (list == null) {
            return;
        }
        for (JavaTypeInstance type : list) {
            if (!this.hasIllegalGenerics(type)) continue;
            abstractFunctionInvokation.setExplicitGenerics(null);
            return;
        }
    }

    @Override
    public void handleStatement(StatementContainer statementContainer) {
    }

    @Override
    public Expression rewriteExpression(Expression expression, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        expression.applyExpressionRewriter(this, ssaIdentifiers, statementContainer, flags);
        if (expression instanceof AbstractFunctionInvokation) {
            this.maybeRewriteExplicitCallTyping((AbstractFunctionInvokation)expression);
        }
        this.maybeRewriteExpressionType(expression.getInferredJavaType());
        return expression;
    }

    @Override
    public ConditionalExpression rewriteExpression(ConditionalExpression expression, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        ConditionalExpression res = (ConditionalExpression)expression.applyExpressionRewriter(this, ssaIdentifiers, statementContainer, flags);
        return res;
    }

    @Override
    public LValue rewriteExpression(LValue lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        this.maybeRewriteExpressionType(lValue.getInferredJavaType());
        return lValue;
    }

    @Override
    public StackSSALabel rewriteExpression(StackSSALabel lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        return lValue;
    }
}

