
(define-library (chibi text-test)
  (import (scheme base) (scheme write) (chibi test) (chibi text))
  (export run-tests)
  (begin
    (define (run-tests)
      (test-begin "(chibi text)")
      (test-assert (text? (string->text "")))
      (test 0 (text-char-length (string->text "")))
      (test 3 (text-char-length (string->text "日本語")))
      (test 0 (text-utf8-length (string->text "")))
      (test 9 (text-utf8-length (string->text "日本語")))
      (test "" (text->string (string->text "")))
      (test "日本語" (text->string (string->text "日本語")))
      (let ((tx (string->text "日本語")))
        (text-insert! tx "!" 0)
        (test "!日本語" (text->string tx))
        (text-insert! tx "!" 2)
        (test "!日!本語" (text->string tx))
        (text-insert! tx "!" 4)
        (test "!日!本!語" (text->string tx))
        (text-insert! tx "!" 6)
        (test "!日!本!語!" (text->string tx)))
      (let ((tx (string->text "abc")))
        (text-insert! tx "あ" 0)
        (test "あabc" (text->string tx))
        (text-insert! tx "い" 2)
        (test "あaいbc" (text->string tx))
        (text-insert! tx "う" 4)
        (test "あaいbうc" (text->string tx))
        (text-insert! tx "え" 6)
        (test "あaいbうcえ" (text->string tx)))
      (let* ((tx (string->text "0123456789"))
             (mk (text-mark! tx 5)))
        (test #\5 (text-ref mk))
        (text-insert! tx "abc" 1)
        (text-insert! tx "xyz" mk)
        (test #\5 (text-ref mk))
        (test "0abc1234xyz56789" (text->string tx)))
      (let* ((tx (string->text "零一二三四五六七八九"))
             (mk (text-mark! tx 5)))
        (text-insert! tx "あいう" 1)
        (text-insert! tx "xyz" mk)
        (text-insert! tx "かきく" mk)
        (test "零あいう一二三四xyzかきく五六七八九" (text->string tx)))
      (let* ((tx (string->text "0123456789"))
             (mk (text-mark! tx 5)))
        (text-insert! tx "abc" mk)
        (text-insert! tx "xyz" mk)
        (test "01234abcxyz56789" (text->string tx)))
      (let* ((tx (string->text "0123456789"))
             (mk1 (text-mark! tx 5))
             (mk2 (text-mark! tx 8))
             (mk3 (text-mark! tx 6)))
        (text-delete! tx mk1 mk2)
        (test "0123489" (text->string tx))
        ;; The current order of mk2/mk3 is unspecified so we insert the same
        ;; value here/
        (text-insert! tx "def" mk2)
        (text-insert! tx "abc" mk1)
        (text-insert! tx "def" mk3)
        (test "01234abcdefdef89" (text->string tx)))
      (let* ((tx (string->text "0123456789"))
             (mk (text-mark! tx 5)))
        (text-insert! tx (make-string 512 #\x) mk)
        (test (string-append "01234" (make-string 512 #\x) "56789")
              (text->string tx))
        (let ((mk2 (text-mark! tx 512)))
          (text-delete! tx 5 517)
          (test "0123456789" (text->string tx))))
      (let* ((tx (string->text "a一二三bc"))
             (mk (text-mark! tx 0)))
        (test #\a (text-forward-char! mk))
        (test #\一 (text-forward-char! mk))
        (test #\二 (text-forward-char! mk))
        (test #\三 (text-forward-char! mk))
        (test #\b (text-forward-char! mk))
        (test #\c (text-forward-char! mk))
        (test #f (text-forward-char! mk))
        (test #\c (text-backward-char! mk))
        (test #\b (text-backward-char! mk))
        (test #\三 (text-backward-char! mk))
        (test #\二 (text-backward-char! mk))
        (test #\一 (text-backward-char! mk))
        (test #\a (text-backward-char! mk))
        (test #f (text-backward-char! mk)))
      (let* ((tx (string->text "abc, (一二三): def"))
             (mk (text-mark! tx 0)))
        (test 3 (mark-offset (text-forward-word! mk)))
        (test 15 (mark-offset (text-forward-word! mk)))
        (test 21 (mark-offset (text-forward-word! mk)))
        (test #f (text-forward-word! mk))
        (test 21 (mark-offset mk))
        (test 18 (mark-offset (text-backward-word! mk)))
        (test 6 (mark-offset (text-backward-word! mk)))
        (test 0 (mark-offset (text-backward-word! mk)))
        (test #f (text-backward-word! mk))
        )
      (let* ((tx (string->text "0123456789\nabcdef\n零一二三四五六七八九"))
             (mk (text-mark! tx 0)))
        (test #t (text-beginning-of-line? mk))
        (test #f (text-end-of-line? mk))
        (test 10 (mark-offset (text-end-of-line! mk)))
        (test #\newline (text-ref mk))
        (test #f (text-beginning-of-line? mk))
        (test #t (text-end-of-line? mk))
        (text-forward-char! mk)
        (text-forward-char! mk)
        (text-forward-char! mk)
        (text-forward-line! mk)
        (test #\二 (text-ref mk))
        (text-forward-char! mk)
        (text-forward-char! mk)
        (text-forward-char! mk)
        (text-forward-char! mk)
        (test #\六 (text-ref mk))
        (text-backward-line! mk)
        (test #\newline (text-ref mk))
        (text-backward-line! mk)
        (test #\6 (text-ref mk))
        )
      (let* ((tx (string->text "0123456789\nabcdef\n零一二三四五六七八九"))
             (mk (text-mark! tx 0)))
        (text-search! mk "一二三")
        (test 30 (mark-offset mk))
        (text-insert! tx "..." mk)
        (test "0123456789\nabcdef\n零一二三...四五六七八九"
              (text->string (mark-text mk))))
      (test-end))))
