/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ccr.action.ImmutableFollowParameters;

public class AutoFollowMetadata
extends AbstractNamedDiffable<MetaData.Custom>
implements XPackPlugin.XPackMetaDataCustom {
    public static final String TYPE = "ccr_auto_follow";
    private static final ParseField PATTERNS_FIELD = new ParseField("patterns", new String[0]);
    private static final ParseField FOLLOWED_LEADER_INDICES_FIELD = new ParseField("followed_leader_indices", new String[0]);
    private static final ParseField HEADERS = new ParseField("headers", new String[0]);
    private static final ConstructingObjectParser<AutoFollowMetadata, Void> PARSER = new ConstructingObjectParser("auto_follow", args -> new AutoFollowMetadata((Map)args[0], (Map)args[1], (Map)args[2]));
    private final Map<String, AutoFollowPattern> patterns;
    private final Map<String, List<String>> followedLeaderIndexUUIDs;
    private final Map<String, Map<String, String>> headers;

    public static AutoFollowMetadata fromXContent(XContentParser parser) throws IOException {
        return (AutoFollowMetadata)PARSER.parse(parser, null);
    }

    public AutoFollowMetadata(Map<String, AutoFollowPattern> patterns, Map<String, List<String>> followedLeaderIndexUUIDs, Map<String, Map<String, String>> headers) {
        this.patterns = Collections.unmodifiableMap(patterns);
        this.followedLeaderIndexUUIDs = Collections.unmodifiableMap(followedLeaderIndexUUIDs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()))));
        this.headers = Collections.unmodifiableMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableMap((Map)e.getValue()))));
    }

    public AutoFollowMetadata(StreamInput in) throws IOException {
        this(in.readMap(StreamInput::readString, AutoFollowPattern::readFrom), in.readMapOfLists(StreamInput::readString, StreamInput::readString), in.readMap(StreamInput::readString, valIn -> valIn.readMap(StreamInput::readString, StreamInput::readString)));
    }

    public Map<String, AutoFollowPattern> getPatterns() {
        return this.patterns;
    }

    public Map<String, List<String>> getFollowedLeaderIndexUUIDs() {
        return this.followedLeaderIndexUUIDs;
    }

    public Map<String, Map<String, String>> getHeaders() {
        return this.headers;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return EnumSet.of(MetaData.XContentContext.SNAPSHOT, MetaData.XContentContext.GATEWAY);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_5_0.minimumCompatibilityVersion();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.patterns, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        out.writeMapOfLists(this.followedLeaderIndexUUIDs, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.headers, StreamOutput::writeString, (valOut, header) -> valOut.writeMap(header, StreamOutput::writeString, StreamOutput::writeString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PATTERNS_FIELD.getPreferredName());
        for (Map.Entry<String, AutoFollowPattern> entry : this.patterns.entrySet()) {
            builder.startObject(entry.getKey());
            builder.value((Object)entry.getValue());
            builder.endObject();
        }
        builder.endObject();
        builder.startObject(FOLLOWED_LEADER_INDICES_FIELD.getPreferredName());
        for (Map.Entry<String, Object> entry : this.followedLeaderIndexUUIDs.entrySet()) {
            builder.field(entry.getKey(), (Iterable)entry.getValue());
        }
        builder.endObject();
        builder.startObject(HEADERS.getPreferredName());
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoFollowMetadata that = (AutoFollowMetadata)o;
        return Objects.equals(this.patterns, that.patterns) && Objects.equals(this.followedLeaderIndexUUIDs, that.followedLeaderIndexUUIDs) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.patterns, this.followedLeaderIndexUUIDs, this.headers);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, AutoFollowPattern> patterns = new HashMap<String, AutoFollowPattern>();
            String fieldName = null;
            XContentParser.Token token = p.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = p.currentName();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    patterns.put(fieldName, (AutoFollowPattern)AutoFollowPattern.PARSER.parse(p, c));
                } else {
                    throw new ElasticsearchParseException("unexpected token [" + token + "]", new Object[0]);
                }
                token = p.nextToken();
            }
            return patterns;
        }, PATTERNS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), FOLLOWED_LEADER_INDICES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), HEADERS);
    }

    public static class AutoFollowPattern
    extends ImmutableFollowParameters
    implements ToXContentObject {
        public static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        public static final ParseField LEADER_PATTERNS_FIELD = new ParseField("leader_index_patterns", new String[0]);
        public static final ParseField FOLLOW_PATTERN_FIELD = new ParseField("follow_index_pattern", new String[0]);
        private static final ConstructingObjectParser<AutoFollowPattern, Void> PARSER = new ConstructingObjectParser("auto_follow_pattern", args -> new AutoFollowPattern((String)args[0], (List)args[1], (String)args[2], (Integer)args[3], (Integer)args[4], (Integer)args[5], (Integer)args[6], (ByteSizeValue)args[7], (ByteSizeValue)args[8], (Integer)args[9], (ByteSizeValue)args[10], (TimeValue)args[11], (TimeValue)args[12]));
        private final String remoteCluster;
        private final List<String> leaderIndexPatterns;
        private final String followIndexPattern;

        public AutoFollowPattern(String remoteCluster, List<String> leaderIndexPatterns, String followIndexPattern, Integer maxReadRequestOperationCount, Integer maxWriteRequestOperationCount, Integer maxOutstandingReadRequests, Integer maxOutstandingWriteRequests, ByteSizeValue maxReadRequestSize, ByteSizeValue maxWriteRequestSize, Integer maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue pollTimeout) {
            super(maxReadRequestOperationCount, maxWriteRequestOperationCount, maxOutstandingReadRequests, maxOutstandingWriteRequests, maxReadRequestSize, maxWriteRequestSize, maxWriteBufferCount, maxWriteBufferSize, maxRetryDelay, pollTimeout);
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.followIndexPattern = followIndexPattern;
        }

        public static AutoFollowPattern readFrom(StreamInput in) throws IOException {
            return new AutoFollowPattern(in.readString(), in.readStringList(), in.readOptionalString(), in);
        }

        private AutoFollowPattern(String remoteCluster, List<String> leaderIndexPatterns, String followIndexPattern, StreamInput in) throws IOException {
            super(in);
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.followIndexPattern = followIndexPattern;
        }

        public boolean match(String indexName) {
            return AutoFollowPattern.match(this.leaderIndexPatterns, indexName);
        }

        public static boolean match(List<String> leaderIndexPatterns, String indexName) {
            return Regex.simpleMatch(leaderIndexPatterns, (String)indexName);
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public String getFollowIndexPattern() {
            return this.followIndexPattern;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.remoteCluster);
            out.writeStringCollection(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexPattern);
            super.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.array(LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns.toArray(new String[0]));
            if (this.followIndexPattern != null) {
                builder.field(FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexPattern);
            }
            this.toXContentFragment(builder);
            return builder;
        }

        public boolean isFragment() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AutoFollowPattern pattern = (AutoFollowPattern)o;
            return this.remoteCluster.equals(pattern.remoteCluster) && this.leaderIndexPatterns.equals(pattern.leaderIndexPatterns) && this.followIndexPattern.equals(pattern.followIndexPattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.remoteCluster, this.leaderIndexPatterns, this.followIndexPattern);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), LEADER_PATTERNS_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FOLLOW_PATTERN_FIELD);
            ImmutableFollowParameters.initParser(PARSER);
        }
    }
}

