/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.groups.GroupOrJob;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.NameResolver;

public class GroupOrJobLookup {
    private final SortedMap<String, GroupOrJob> groupOrJobLookup = new TreeMap<String, GroupOrJob>();

    public GroupOrJobLookup(Collection<Job> jobs) {
        jobs.forEach(this::put);
    }

    private void put(Job job) {
        if (this.groupOrJobLookup.containsKey(job.getId())) {
            throw new ResourceAlreadyExistsException(Messages.getMessage("job and group names must be unique but job [{0}] and group [{0}] have the same name", job.getId()), new Object[0]);
        }
        this.groupOrJobLookup.put(job.getId(), new GroupOrJob.SingleJob(job));
        for (String groupName : job.getGroups()) {
            GroupOrJob oldGroup = (GroupOrJob)this.groupOrJobLookup.get(groupName);
            if (oldGroup == null) {
                this.groupOrJobLookup.put(groupName, new GroupOrJob.Group(Collections.singletonList(job)));
                continue;
            }
            if (!oldGroup.isGroup()) {
                throw new ResourceAlreadyExistsException(Messages.getMessage("job and group names must be unique but job [{0}] and group [{0}] have the same name", groupName), new Object[0]);
            }
            ArrayList<Job> groupJobs = new ArrayList<Job>(oldGroup.jobs());
            groupJobs.add(job);
            this.groupOrJobLookup.put(groupName, new GroupOrJob.Group(groupJobs));
        }
    }

    public Set<String> expandJobIds(String expression) {
        return new GroupOrJobResolver().expand(expression);
    }

    public Set<String> expandGroupIds(String expression) {
        return new GroupResolver().expand(expression);
    }

    public boolean isGroupOrJob(String id) {
        return this.groupOrJobLookup.containsKey(id);
    }

    private class GroupResolver
    extends NameResolver {
        private GroupResolver() {
        }

        @Override
        protected Set<String> keys() {
            return this.nameSet();
        }

        @Override
        protected Set<String> nameSet() {
            return GroupOrJobLookup.this.groupOrJobLookup.entrySet().stream().filter(entry -> ((GroupOrJob)entry.getValue()).isGroup()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        }

        @Override
        protected List<String> lookup(String key) {
            GroupOrJob groupOrJob = (GroupOrJob)GroupOrJobLookup.this.groupOrJobLookup.get(key);
            if (groupOrJob == null || !groupOrJob.isGroup()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(key);
        }
    }

    private class GroupOrJobResolver
    extends NameResolver {
        private GroupOrJobResolver() {
        }

        @Override
        protected Set<String> keys() {
            return GroupOrJobLookup.this.groupOrJobLookup.keySet();
        }

        @Override
        protected Set<String> nameSet() {
            return GroupOrJobLookup.this.groupOrJobLookup.values().stream().filter(groupOrJob -> !groupOrJob.isGroup()).map(groupOrJob -> groupOrJob.jobs().get(0).getId()).collect(Collectors.toSet());
        }

        @Override
        protected List<String> lookup(String key) {
            GroupOrJob groupOrJob = (GroupOrJob)GroupOrJobLookup.this.groupOrJobLookup.get(key);
            return groupOrJob == null ? Collections.emptyList() : groupOrJob.jobs().stream().map(Job::getId).collect(Collectors.toList());
        }
    }
}

