/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String executor;
    final String shardActionName;

    protected TransportInstanceSingleOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.executor = this.executor();
        this.shardActionName = actionName + "[s]";
        transportService.registerRequestHandler(this.shardActionName, request, this.executor, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract String executor();

    protected abstract void shardOperation(Request var1, ActionListener<Response> var2);

    protected abstract Response newResponse();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, Request request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ((InstanceShardOperationRequest)request).concreteIndex());
    }

    protected abstract void resolveRequest(ClusterState var1, Request var2);

    protected boolean retryOnFailure(Exception e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2);

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            TransportInstanceSingleOperationAction.this.shardOperation(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        TransportInstanceSingleOperationAction.this.logger.warn("failed to send response for get", (Throwable)inner);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private ShardIterator shardIt;
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
        }

        public void start() {
            ClusterState state = this.this$0.clusterService.state();
            this.observer = new ClusterStateObserver(state, this.this$0.clusterService, ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.doStart(state);
        }

        protected void doStart(ClusterState clusterState) {
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(clusterState);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                ((InstanceShardOperationRequest)this.request).concreteIndex(this.this$0.indexNameExpressionResolver.concreteWriteIndex(clusterState, (IndicesRequest)this.request).getName());
                this.this$0.resolveRequest(clusterState, this.request);
                blockException = this.this$0.checkRequestBlock(clusterState, this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(clusterState, this.request);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
                return;
            }
            if (this.shardIt.size() == 0) {
                this.retry(null);
                return;
            }
            assert (this.shardIt.size() == 1);
            ShardRouting shard = this.shardIt.nextOrNull();
            assert (shard != null);
            if (!shard.active()) {
                this.retry(null);
                return;
            }
            ((InstanceShardOperationRequest)this.request).shardId = this.shardIt.shardId();
            DiscoveryNode node = clusterState.nodes().get(shard.currentNodeId());
            this.this$0.transportService.sendRequest(node, this.this$0.shardActionName, (TransportRequest)this.request, this.this$0.transportOptions(), new TransportResponseHandler<Response>(){

                @Override
                public Response read(StreamInput in) throws IOException {
                    Object response = AsyncSingleAction.this.this$0.newResponse();
                    ((ActionResponse)response).readFrom(in);
                    return response;
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    AsyncSingleAction.this.listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    Throwable cause = exp.unwrapCause();
                    if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure(exp)) {
                        AsyncSingleAction.this.retry((Exception)cause);
                    } else {
                        AsyncSingleAction.this.listener.onFailure(exp);
                    }
                }
            });
        }

        void retry(@Nullable Exception failure) {
            if (this.observer.isTimedOut()) {
                Exception listenFailure = failure;
                if (listenFailure == null) {
                    listenFailure = this.shardIt == null ? new UnavailableShardsException(((InstanceShardOperationRequest)this.request).concreteIndex(), -1, "Timeout waiting for [{}], request: {}", ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName) : new UnavailableShardsException(this.shardIt.shardId(), "[{}] shardIt, [{}] active : Timeout waiting for [{}], request: {}", this.shardIt.size(), this.shardIt.sizeActive(), ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName);
                }
                this.listener.onFailure(listenFailure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.doStart(AsyncSingleAction.this.observer.setAndGetObservedState());
                }
            }, ((InstanceShardOperationRequest)this.request).timeout());
        }
    }
}

