/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.search.MultiValueMode;

public class GlobalOrdinalsIndexFieldData
extends AbstractIndexComponent
implements IndexOrdinalsFieldData,
Accountable {
    private final String fieldName;
    private final long memorySizeInBytes;
    private final OrdinalMap ordinalMap;
    private final Atomic[] atomicReaders;
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected GlobalOrdinalsIndexFieldData(IndexSettings indexSettings, String fieldName, AtomicOrdinalsFieldData[] segmentAfd, OrdinalMap ordinalMap, long memorySizeInBytes, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(indexSettings);
        this.fieldName = fieldName;
        this.memorySizeInBytes = memorySizeInBytes;
        this.ordinalMap = ordinalMap;
        this.atomicReaders = new Atomic[segmentAfd.length];
        for (int i = 0; i < segmentAfd.length; ++i) {
            this.atomicReaders[i] = new Atomic(segmentAfd[i], ordinalMap, i);
        }
        this.scriptFunction = scriptFunction;
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new UnsupportedOperationException("no global ordinals sorting yet");
    }

    @Override
    public void clear() {
    }

    public long ramBytesUsed() {
        return this.memorySizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicReaders[context.ord];
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return this.ordinalMap;
    }

    private final class Atomic
    extends AbstractAtomicOrdinalsFieldData {
        private final AtomicOrdinalsFieldData afd;
        private final OrdinalMap ordinalMap;
        private final int segmentIndex;

        private Atomic(AtomicOrdinalsFieldData afd, OrdinalMap ordinalMap, int segmentIndex) {
            super(GlobalOrdinalsIndexFieldData.this.scriptFunction);
            this.afd = afd;
            this.ordinalMap = ordinalMap;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public SortedSetDocValues getOrdinalsValues() {
            SortedSetDocValues values = this.afd.getOrdinalsValues();
            if (values.getValueCount() == this.ordinalMap.getValueCount()) {
                return values;
            }
            SortedSetDocValues[] bytesValues = new SortedSetDocValues[GlobalOrdinalsIndexFieldData.this.atomicReaders.length];
            for (int i = 0; i < bytesValues.length; ++i) {
                bytesValues[i] = ((GlobalOrdinalsIndexFieldData)GlobalOrdinalsIndexFieldData.this).atomicReaders[i].afd.getOrdinalsValues();
            }
            return new GlobalOrdinalMapping(this.ordinalMap, bytesValues, this.segmentIndex);
        }

        public long ramBytesUsed() {
            return this.afd.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.afd.getChildResources();
        }

        @Override
        public void close() {
        }
    }
}

