/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.drag.DragManager;

public class DragOperation
implements DockingConstants {
    public static final String DRAG_IMAGE = "DragOperation.DRAG_IMAGE";
    private Component dragSource;
    private Component dockable;
    private DockingPort parentDockingPort;
    private Point mouseOffset;
    private Point currentMouse;
    private EventListener[] cachedListeners;
    private DragManager dragListener;
    private DockingPort targetPort;
    private String targetRegion;
    private boolean overWindow;
    private boolean pseudoDrag;
    private long started;
    private Dockable dockableRef;
    private DockingPort sourcePort;

    public DragOperation(Component dockable, Point dragOrigin, MouseEvent evt) {
        if (dockable == null) {
            throw new NullPointerException("'dockable' parameter cannot be null.");
        }
        if (evt == null) {
            throw new NullPointerException("'evt' parameter cannot be null.");
        }
        if (!(evt.getSource() instanceof Component)) {
            throw new IllegalArgumentException("'evt.getSource()' must be an instance of java.awt.Component.");
        }
        if (dragOrigin == null) {
            dragOrigin = evt.getPoint();
        }
        this.init(dockable, (Component)evt.getSource(), dragOrigin, false);
    }

    public DragOperation(Component dockable, Component dragSource, Point currentMouse) {
        this.init(dockable, dragSource, currentMouse, true);
    }

    private void init(Component dockable, Component dragSource, Point currentMouse, boolean fakeDrag) {
        this.dockable = dockable;
        this.dragSource = dragSource;
        this.currentMouse = currentMouse;
        this.mouseOffset = this.calculateMouseOffset(currentMouse);
        this.pseudoDrag = fakeDrag;
        if (!fakeDrag) {
            this.parentDockingPort = (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, dockable));
        }
        this.sourcePort = DockingManager.getDockingPort(dockable);
        this.started = -1L;
    }

    private Point calculateMouseOffset(Point evtPoint) {
        if (evtPoint == null) {
            return null;
        }
        Point dockableLoc = this.dockable.getLocationOnScreen();
        SwingUtilities.convertPointToScreen(evtPoint, this.dragSource);
        Point offset = new Point();
        offset.x = dockableLoc.x - evtPoint.x;
        offset.y = dockableLoc.y - evtPoint.y;
        return offset;
    }

    public Component getDockable() {
        return this.dockable;
    }

    public Dockable getDockableReference() {
        if (this.dockableRef == null) {
            this.dockableRef = DockingManager.getDockable(this.dockable);
        }
        return this.dockableRef;
    }

    public Point getMouseOffset() {
        return (Point)this.mouseOffset.clone();
    }

    public void updateMouse(MouseEvent me) {
        if (me != null && me.getSource() == this.dragSource) {
            this.currentMouse = me.getPoint();
        }
    }

    public Point getCurrentMouse() {
        return this.getCurrentMouse(false);
    }

    public Point getCurrentMouse(boolean relativeToScreen) {
        Point p = (Point)this.currentMouse.clone();
        if (relativeToScreen) {
            SwingUtilities.convertPointToScreen(p, this.dragSource);
        }
        return p;
    }

    public Rectangle getDragRect(boolean relativeToScreen) {
        Point p = this.getCurrentMouse(relativeToScreen);
        Point offset = this.getMouseOffset();
        p.x += offset.x;
        p.y += offset.y;
        Rectangle r = new Rectangle(this.getDragSize());
        r.setLocation(p);
        return r;
    }

    public Point getCurrentMouse(Component target) {
        if (target == null || !target.isVisible()) {
            return null;
        }
        return SwingUtilities.convertPoint(this.dragSource, this.currentMouse, target);
    }

    public Dimension getDragSize() {
        return this.dockable.getSize();
    }

    public Component getDragSource() {
        return this.dragSource;
    }

    public void setTarget(DockingPort port, String region) {
        this.targetPort = port;
        this.targetRegion = region == null ? "UNKNOWN" : region;
    }

    public DockingPort getTargetPort() {
        return this.targetPort;
    }

    public String getTargetRegion() {
        return this.targetRegion;
    }

    public EventListener[] getCachedListeners() {
        return this.cachedListeners == null ? new EventListener[]{} : this.cachedListeners;
    }

    public void setCachedListeners(EventListener[] listeners) {
        this.cachedListeners = listeners;
    }

    public DragManager getDragListener() {
        return this.dragListener;
    }

    public void setDragListener(DragManager listener) {
        this.dragListener = listener;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean overWindow) {
        this.overWindow = overWindow;
    }

    public boolean isPseudoDrag() {
        return this.pseudoDrag;
    }

    public DockingPort getParentDockingPort() {
        return this.parentDockingPort;
    }

    public void start() {
        if (this.started == -1L) {
            this.started = System.currentTimeMillis();
        }
    }

    public long getStartTime() {
        return this.started;
    }

    public DockingPort getSourcePort() {
        return this.sourcePort;
    }
}

