/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Picture;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class CoreUtils {
    public static final String MODULE = "CoreUtils";
    static GalleryRemoteCore core = null;

    public static void initCore() {
        core = GalleryRemote._().getCore();
    }

    public static void deleteSelectedPictures() {
        int i;
        JList jPicturesList = core.getPicturesList();
        int[] indices = jPicturesList.getSelectedIndices();
        int selected = jPicturesList.getSelectedIndex();
        Picture reselect = null;
        Arrays.sort(indices);
        boolean found = false;
        for (i = selected + 1; i < jPicturesList.getModel().getSize(); ++i) {
            if (Arrays.binarySearch(indices, i) >= 0) continue;
            found = true;
            break;
        }
        if (!found) {
            for (i = selected - 1; i >= 0; --i) {
                if (Arrays.binarySearch(indices, i) >= 0) continue;
                found = true;
                break;
            }
        }
        if (found) {
            reselect = (Picture)jPicturesList.getModel().getElementAt(i);
        }
        core.getCurrentAlbum().removePictures(indices);
        if (reselect != null) {
            jPicturesList.setSelectedValue(reselect, true);
        }
    }

    public static void movePicturesUp() {
        JList jPicturesList = core.getPicturesList();
        int[] indices = jPicturesList.getSelectedIndices();
        int[] reselect = new int[indices.length];
        Arrays.sort(indices);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] > 0) {
                Album currentAlbum = core.getCurrentAlbum();
                Picture buf = currentAlbum.getPicture(indices[i]);
                currentAlbum.setPicture(indices[i], currentAlbum.getPicture(indices[i] - 1));
                currentAlbum.setPicture(indices[i] - 1, buf);
                reselect[i] = indices[i] - 1;
                continue;
            }
            reselect[i] = indices[i];
        }
        jPicturesList.setSelectedIndices(reselect);
        jPicturesList.ensureIndexIsVisible(jPicturesList.getSelectedIndex());
    }

    public static void movePicturesDown() {
        JList jPicturesList = core.getPicturesList();
        int[] indices = jPicturesList.getSelectedIndices();
        int[] reselect = new int[indices.length];
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            Album currentAlbum = core.getCurrentAlbum();
            if (indices[i] < currentAlbum.sizePictures() - 1) {
                Picture buf = currentAlbum.getPicture(indices[i]);
                currentAlbum.setPicture(indices[i], currentAlbum.getPicture(indices[i] + 1));
                currentAlbum.setPicture(indices[i] + 1, buf);
                reselect[i] = indices[i] + 1;
                continue;
            }
            reselect[i] = indices[i];
        }
        jPicturesList.setSelectedIndices(reselect);
        jPicturesList.ensureIndexIsVisible(jPicturesList.getSelectedIndex());
    }

    public static void selectNextPicture() {
        JList jPicturesList = core.getPicturesList();
        int i = jPicturesList.getSelectedIndex();
        if (i < jPicturesList.getModel().getSize() - 1) {
            jPicturesList.setSelectedIndex(i + 1);
            jPicturesList.ensureIndexIsVisible(i + 1);
        }
    }

    public static void selectPrevPicture() {
        JList jPicturesList = core.getPicturesList();
        int i = jPicturesList.getSelectedIndex();
        if (i > 0) {
            jPicturesList.setSelectedIndex(i - 1);
            jPicturesList.ensureIndexIsVisible(i - 1);
        }
    }

    static class FileCellRenderer
    extends DefaultListCellRenderer {
        FileCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            Album currentAlbum = core.getCurrentAlbum();
            if (null != currentAlbum && null != value && -1 != index) {
                try {
                    ImageIcon icon;
                    Picture p = currentAlbum.getPicture(index);
                    if (p.isOnline()) {
                        if (p.getParentAlbum() != p.getAlbumOnServer() || p.getIndex() != p.getIndexOnServer()) {
                            this.setForeground(Color.red);
                        } else {
                            this.setForeground(Color.green);
                        }
                    }
                    if (GalleryRemote._().properties.getShowThumbnails() && (icon = core.getThumbnail(p)) != null) {
                        this.setIcon(icon);
                        this.setIconTextGap(4 + GalleryRemote._().properties.getThumbnailSize().width - icon.getIconWidth());
                    }
                    StringBuffer text = new StringBuffer();
                    text.append("<html><p>");
                    if (p.isOnline()) {
                        text.append(p.getName());
                    } else {
                        File f = p.getSource();
                        text.append(f.getName());
                        if (GalleryRemote._().properties.getShowPath()) {
                            text.append(" [").append(f.getParent()).append("]</p>");
                        }
                    }
                    if (p.getCaption() != null && this.getIcon() != null) {
                        text.append("<p><font color=\"gray\">").append(p.getEscapedCaption()).append("</font></p>");
                    }
                    text.append("</html>");
                    this.setText(text.toString());
                }
                catch (Exception e) {
                    this.setText("Problem...");
                    Log.logException(1, CoreUtils.MODULE, e);
                }
            } else {
                this.setText("dummy");
            }
            return this;
        }
    }
}

