/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

public class KStreamAggregate<K, V, T>
implements KStreamAggProcessorSupplier<K, K, V, T> {
    private final String storeName;
    private final Initializer<T> initializer;
    private final Aggregator<? super K, ? super V, T> aggregator;
    private boolean sendOldValues = false;

    public KStreamAggregate(String storeName, Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator) {
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, T> view() {
        return new KTableValueGetterSupplier<K, T>(){

            @Override
            public KTableValueGetter<K, T> get() {
                return new KStreamAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamAggregate.this.storeName};
            }
        };
    }

    private class KStreamAggregateValueGetter
    implements KTableValueGetter<K, T> {
        private KeyValueStore<K, T> store;

        private KStreamAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (KeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
        }

        @Override
        public T get(K key) {
            return this.store.get(key);
        }
    }

    private class KStreamAggregateProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, T> store;
        private TupleForwarder<K, T> tupleForwarder;

        private KStreamAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KStreamAggregate.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KStreamAggregate.this.sendOldValues), KStreamAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null || value == null) {
                return;
            }
            Object oldAgg = this.store.get(key);
            if (oldAgg == null) {
                oldAgg = KStreamAggregate.this.initializer.apply();
            }
            Object newAgg = oldAgg;
            newAgg = KStreamAggregate.this.aggregator.apply(key, value, newAgg);
            this.store.put(key, newAgg);
            this.tupleForwarder.maybeForward(key, newAgg, oldAgg);
        }
    }
}

