/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.natutil;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ic.doc.natutil.MacroException;

public class MacroExpander {
    private static final int SYNTAX_ESCAPE = 92;
    private static final int SYNTAX_SUBST = 36;
    private static final int SYNTAX_BEGIN = 123;
    private static final int SYNTAX_END = 125;
    private static final int SYNTAX_DEFAULT = 61;
    private Map _macro_table = new HashMap();

    public void addMacro(String string, String string2) throws MacroException {
        if (this._macro_table.containsKey(string)) {
            throw new MacroException("macro \"" + string + "\" already defined");
        }
        this._macro_table.put(string, string2);
    }

    public void expandMacros(Reader reader, Writer writer) throws MacroException {
        try {
            int n;
            while ((n = this.readMacroChar(reader)) != -1) {
                switch (n) {
                    case -36: {
                        this.expandNextMacro(reader, writer);
                        break;
                    }
                    case -125: 
                    case -123: 
                    case -61: {
                        writer.write(-n);
                        break;
                    }
                    default: {
                        writer.write(n);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new MacroException("I/O exception while reading input: " + iOException.getMessage());
        }
    }

    public String expandMacros(String string) throws MacroException {
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        this.expandMacros(stringReader, stringWriter);
        return stringWriter.toString();
    }

    private void expandNextMacro(Reader reader, Writer writer) throws IOException, MacroException {
        int n;
        if (reader.read() != 123) {
            throw new MacroException("syntax error in macro: 123 expected");
        }
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.readMacroChar(reader)) != -125) {
            switch (n) {
                case -123: 
                case -36: {
                    throw new MacroException("syntax error in macro: \"" + -n + "\" character not expected");
                }
                case -61: {
                    string = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (string == null) {
            string = stringBuffer.toString();
        } else {
            string2 = stringBuffer.toString();
        }
        String string3 = (String)this._macro_table.get(string);
        if (string3 == null) {
            if (string2 != null) {
                string3 = string2;
            } else {
                throw new MacroException("macro \"" + string + "\" not defined");
            }
        }
        writer.write(string3);
    }

    private int readMacroChar(Reader reader) throws IOException, MacroException {
        int n = reader.read();
        switch (n) {
            case 92: {
                n = reader.read();
                if (n == -1) {
                    throw new MacroException("premature end of input");
                }
                return n;
            }
            case 36: 
            case 61: 
            case 123: 
            case 125: {
                return -n;
            }
        }
        return n;
    }

    public void removeMacro(String string) {
        this._macro_table.remove(string);
    }
}

