/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class KeyboardModifierGestureShortcut
extends Shortcut {
    private final KeyStroke myStroke;
    private final KeyboardGestureAction.ModifierType myType;

    @NotNull
    public static Shortcut newInstance(KeyboardGestureAction.ModifierType type, KeyStroke stroke) {
        switch (type) {
            case dblClick: {
                DblClick dblClick = new DblClick(stroke);
                if (dblClick == null) {
                    KeyboardModifierGestureShortcut.$$$reportNull$$$0(0);
                }
                return dblClick;
            }
            case hold: {
                Hold hold = new Hold(stroke);
                if (hold == null) {
                    KeyboardModifierGestureShortcut.$$$reportNull$$$0(1);
                }
                return hold;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected KeyboardModifierGestureShortcut(KeyStroke stroke, KeyboardGestureAction.ModifierType type) {
        this.myStroke = stroke;
        this.myType = type;
    }

    public KeyStroke getStroke() {
        return this.myStroke;
    }

    public KeyboardGestureAction.ModifierType getType() {
        return this.myType;
    }

    @Override
    public boolean isKeyboard() {
        return true;
    }

    @Override
    public boolean startsWith(@NotNull Shortcut sc) {
        if (sc == null) {
            KeyboardModifierGestureShortcut.$$$reportNull$$$0(2);
        }
        if (!(sc instanceof KeyboardModifierGestureShortcut)) {
            return false;
        }
        KeyboardModifierGestureShortcut other = (KeyboardModifierGestureShortcut)sc;
        if (this.myType.equals((Object)other.myType)) {
            if (this.myStroke.getModifiers() != other.myStroke.getModifiers()) {
                return false;
            }
            return other.myStroke.getKeyCode() != -1 || other.myStroke.getKeyCode() == this.myStroke.getKeyCode();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyboardModifierGestureShortcut that = (KeyboardModifierGestureShortcut)o;
        if (this.myStroke != null ? !this.myStroke.equals(that.myStroke) : that.myStroke != null) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result2 = this.myStroke != null ? this.myStroke.hashCode() : 0;
        result2 = 31 * result2 + (this.myType != null ? this.myType.hashCode() : 0);
        return result2;
    }

    public String toString() {
        String s = this.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
        s = s + KeymapUtil.getKeystrokeText(this.getStroke());
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/KeyboardModifierGestureShortcut";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/KeyboardModifierGestureShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Hold
    extends KeyboardModifierGestureShortcut {
        public Hold(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.hold);
        }
    }

    public static class DblClick
    extends KeyboardModifierGestureShortcut {
        public DblClick(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.dblClick);
        }
    }
}

