/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class LineEndDecorator {
    private static final int myArrowSize = 9;
    private static final Shape myArrowPolygon = new Polygon(new int[]{0, 9, 0, 0}, new int[]{0, 4, 9, 0}, 4);

    public static Shape getArrowShape(Line2D line, Point2D intersectionPoint) {
        double deltaY = line.getP2().getY() - line.getP1().getY();
        double length = Math.sqrt(Math.pow(deltaY, 2.0) + Math.pow(line.getP2().getX() - line.getP1().getX(), 2.0));
        double theta = Math.asin(deltaY / length);
        if (line.getP1().getX() > line.getP2().getX()) {
            theta = Math.PI - theta;
        }
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, 9.0, 4.0);
        Shape polygon = rotate.createTransformedShape(myArrowPolygon);
        AffineTransform move = AffineTransform.getTranslateInstance(intersectionPoint.getX() - 9.0, intersectionPoint.getY() - 4.0);
        polygon = move.createTransformedShape(polygon);
        return polygon;
    }
}

