/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionFilter;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssNoGenericFontNameInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CssNoGenericFontNameInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)cssDeclaration);
                if ("font-family".equals(propertyName) && CssNoGenericFontNameInspection.isGenericFontFamilyMissed(cssDeclaration)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = CssFixFactory.getInstance().insertGenericFontFamilyAction(cssDeclaration);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)cssDeclaration, CssBundle.message((String)"css.overwritten.nongeneric.fontname.message", (Object[])new Object[]{propertyName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
                }
            }
        };
        if (cssElementVisitor == null) {
            CssNoGenericFontNameInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    public static boolean isGenericFontFamilyMissed(@NotNull CssDeclaration cssDeclaration) {
        CssTerm[] terms;
        if (cssDeclaration == null) {
            CssNoGenericFontNameInspection.$$$reportNull$$$0(2);
        }
        if (CssUtil.isInsideFontFace((PsiElement)cssDeclaration)) {
            return false;
        }
        CssTermList termList = cssDeclaration.getValue();
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)cssDeclaration);
        if (language == null) {
            return false;
        }
        CssInspectionFilter inspectionFilter = (CssInspectionFilter)CssInspectionFilter.INSTANCE.forLanguage(language);
        if (inspectionFilter != null && !inspectionFilter.isValueShouldBeValidatedWithCssScheme(termList)) {
            return false;
        }
        CssTerm[] cssTermArray = terms = termList != null ? termList.getTerms() : CssTerm.TERMS_EMPTY_ARRAY;
        if (terms.length == 1 && ArrayUtil.contains((String)terms[0].getText().trim(), (String[])new String[]{"initial", "inherit", "revert", "unset"})) {
            return false;
        }
        for (CssTerm term : terms) {
            if (!CssElementDescriptorConstants.GENERIC_FONT_NAMES.contains(StringUtil.unquoteString((String)term.getText().trim()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/bugs/CssNoGenericFontNameInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/bugs/CssNoGenericFontNameInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isGenericFontFamilyMissed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

