/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.dialects.base.SqlObjectBuilderImplKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0014J\u0015\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010&\u001a\n (*\u0004\u0018\u00010'0'2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010)\u001a\n (*\u0004\u0018\u00010'0'2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010-\u001a\u00020\t2\u0006\u0010\n\u001a\u00020.2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010/\u001a\u00020\t2\u0006\u0010\n\u001a\u0002002\u0006\u0010\f\u001a\u00020\rH\u0014J\u001b\u00101\u001a\r\u0012\t\u0012\u00070\u001e\u00a2\u0006\u0002\b\u0015022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00103\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\t2\u0006\u0010\n\u001a\u0002052\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u00106\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u00107\u001a\u0004\u0018\u00010\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u00108\u001a\u0004\u0018\u00010\u001e2\b\u0010\f\u001a\u0004\u0018\u000109H\u0002J\u0018\u0010:\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010;\u001a\u00020\t2\u0006\u0010\n\u001a\u00020<2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010=\u001a\u00020\t2\u0006\u0010\n\u001a\u00020>2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0015\u0010?\u001a\u00070@\u00a2\u0006\u0002\b\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010A\u001a\u00020\t2\u0006\u0010\n\u001a\u00020B2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010C\u001a\u00020\t2\u0006\u0010\n\u001a\u00020D2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0017\u0010E\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\bF2\u0006\u0010\f\u001a\u00020\rH\u0002J<\u0010G\u001a.\u0012\f\u0012\n (*\u0004\u0018\u00010I0I (*\u0015\u0012\f\u0012\n (*\u0004\u0018\u00010I0I02\u00a2\u0006\u0002\b\u00150H\u00a2\u0006\u0002\b\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0017\u0010J\u001a\t\u0018\u00010K\u00a2\u0006\u0002\bF2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010L\u001a\u00020\t2\u0006\u0010\n\u001a\u00020M2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0017\u0010N\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\bF2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010O\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010P\u001a\u00020\t2\u0006\u0010\n\u001a\u00020M2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010Q\u001a\u00020\t2\u0006\u0010\n\u001a\u00020R2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010S\u001a\u00020\t2\u0006\u0010\n\u001a\u00020T2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010U\u001a\u00020\t2\u0006\u0010\n\u001a\u00020R2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u000e\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0XH\u0004J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010[\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010[\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010\\\u001a\u00020\t2\u0006\u0010\n\u001a\u00020.H\u0014J\"\u0010]\u001a\u0004\u0018\u0001H^\"\u0006\b\u0000\u0010^\u0018\u00012\b\u0010_\u001a\u0004\u0018\u00010\u0005H\u0084\b\u00a2\u0006\u0002\u0010`J)\u0010]\u001a\u0004\u0018\u00010\u00052\b\u0010_\u001a\u0004\u0018\u00010\u00052\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020$0bH\u0084\bJ\u001c\u0010]\u001a\u0004\u0018\u00010\u00052\b\u0010c\u001a\u0004\u0018\u00010\u00052\u0006\u0010d\u001a\u00020\u0004H\u0004J\u0019\u0010e\u001a\u0004\u0018\u00010f2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0004\u00a2\u0006\u0002\u0010gJ)\u0010h\u001a\u0004\u0018\u00010\u00052\b\u0010i\u001a\u0004\u0018\u00010\u00052\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020$0bH\u0084\bJ\u001c\u0010h\u001a\u0004\u0018\u00010\u00052\b\u0010i\u001a\u0004\u0018\u00010\u00052\u0006\u0010d\u001a\u00020\u0004H\u0004J\u0014\u0010j\u001a\u0004\u0018\u00010\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0004J'\u0010k\u001a\u00020\t2\b\u0010_\u001a\u0004\u0018\u00010\u00052\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0bH\u0084\bJ'\u0010l\u001a\u00020\t2\b\u0010m\u001a\u0004\u0018\u00010\u00052\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0bH\u0084\bJ\u001a\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010p\u001a\u00020qH\u0004J\u0018\u0010r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010s\u001a\u00020o*\u00020\u001e2\b\b\u0002\u0010p\u001a\u00020qH\u0004J\u000e\u0010t\u001a\u0004\u0018\u00010\u001e*\u00020\u0005H\u0004R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006u"}, d2={"Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "Lcom/intellij/sql/database/SqlObjectBuilder;", "()V", "elementType", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/PsiElement;", "getElementType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/tree/IElementType;", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "build", "Lcom/intellij/sql/psi/SqlElement;", "Lcom/intellij/database/model/basic/BasicModElement;", "buildArgument", "Lcom/intellij/database/model/basic/BasicModArgument;", "buildArgumentDir", "Lcom/intellij/database/model/DasArgument$Direction;", "Lorg/jetbrains/annotations/NotNull;", "buildArranged", "Lcom/intellij/database/model/basic/BasicModArrangedElement;", "buildArrangedPos", "", "buildBasicElement", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckPredicate", "", "buildColumniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "buildColumniationRefs", "", "buildFkIsDeferrable", "", "buildFkIsDeferred", "buildFkOnDelete", "Lcom/intellij/database/model/properties/CascadeRule;", "kotlin.jvm.PlatformType", "buildFkOnUpdate", "buildFkRefColumns", "buildFkRefSchemaName", "buildFkRefTableName", "buildForeignKey", "Lcom/intellij/database/model/basic/BasicModForeignKey;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexReverseColumns", "", "buildIndexUnique", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyIsPrimary", "buildNameFromPsiElement", "buildNameFromRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "buildNamedElement", "buildNamespace", "Lcom/intellij/database/model/basic/BasicModNamespace;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/DasRoutine$Kind;", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerCondition", "Lorg/jetbrains/annotations/Nullable;", "buildTriggerEvents", "", "Lcom/intellij/database/model/TrigEvent;", "buildTriggerTurn", "Lcom/intellij/database/model/TrigTurn;", "buildTyped", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "buildTypedDef", "buildTypedNotNull", "buildTypedType", "buildView", "Lcom/intellij/database/model/basic/BasicModView;", "buildViewColumn", "Lcom/intellij/database/model/basic/BasicModTableOrViewColumn;", "buildViewSource", "collectNames", "ref", "Lcom/intellij/database/model/MultiRef;", "extractType", "Lcom/intellij/database/model/DataType;", "finalize", "finalizeForeignKey", "findChild", "T", "el", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "action", "Lkotlin/Function1;", "parent", "type", "findInt", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "findSibling", "element", "findString", "forEachChild", "forEachSibling", "first", "getViewQuery", "Lcom/intellij/database/script/SimpleCompositeText;", "kind", "Lcom/intellij/database/script/CompositeText$Kind;", "partialBuild", "asComposite", "extractName", "intellij.database.dialects"})
public abstract class SqlObjectBuilderImpl
implements SqlObjectBuilder {
    public void partialBuild(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
    }

    public void build(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof DbElement || source instanceof BasicElement) {
            SqlObjectBuilderImplKt.getLog().error("Unexpected source: " + source.getClass().getSimpleName());
        }
        this.build((BasicModElement)obj, source);
    }

    public void build(@NotNull DasObject obj, @NotNull SqlElement source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlCommentStatementImpl.class) != null) {
            String comment;
            SqlElement sqlElement = source;
            if (!(sqlElement instanceof SqlStringLiteralExpressionImpl)) {
                sqlElement = null;
            }
            SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)sqlElement;
            String string = comment = sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
            if (obj instanceof BasicModNamedElement) {
                ((BasicModNamedElement)obj).setComment(comment);
            }
        }
    }

    public void finalize(@NotNull DasObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.finalize((BasicModElement)obj);
    }

    public void finalize(@NotNull BasicModElement obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (obj instanceof BasicModForeignKey) {
            this.finalizeForeignKey((BasicModForeignKey)obj);
        }
    }

    protected void finalizeForeignKey(@NotNull BasicModForeignKey obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        BasicTableOrView basicTableOrView = obj.getRefTable();
        if (basicTableOrView == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrView, (String)"obj.refTable ?: return");
        BasicTableOrView refTable = basicTableOrView;
        List<String> list = obj.getRefColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"obj.refColNames");
        List<String> refCols = list;
        if (refCols.isEmpty()) {
            BasicKey key2;
            BasicKey basicKey = key2 = refTable.getPrimaryKey();
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
            if (key2 != null) {
                obj.setRefColNames(key2.getColNames());
            }
        } else {
            BasicKey key3;
            BasicKey basicKey = key3 = refTable.getKeys().find((Predicate<? extends BasicKey>)new Predicate<BasicKey>(refCols){
                final /* synthetic */ List $refCols;

                public final boolean test(BasicKey k) {
                    return k.areColNames(this.$refCols);
                }
                {
                    this.$refCols = list;
                }
            });
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
        }
    }

    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof BasicModNamespace) {
            this.buildNamespace((BasicModNamespace)obj, source);
        } else if (basicModElement instanceof BasicModArgument) {
            this.buildArgument((BasicModArgument)obj, source);
        } else if (basicModElement instanceof BasicModForeignKey) {
            this.buildForeignKey((BasicModForeignKey)obj, source);
        } else if (basicModElement instanceof BasicModIndex) {
            this.buildIndex((BasicModIndex)obj, source);
        } else if (basicModElement instanceof BasicModKey) {
            this.buildKey((BasicModKey)obj, source);
        } else if (basicModElement instanceof BasicModRoutine) {
            this.buildRoutine((BasicModRoutine)obj, source);
        } else if (basicModElement instanceof BasicModTrigger) {
            this.buildTrigger((BasicModTrigger)obj, source);
        } else if (basicModElement instanceof BasicModCheck) {
            this.buildCheck((BasicModCheck)obj, source);
        } else if (basicModElement instanceof BasicModView) {
            this.buildView((BasicModView)obj, source);
        } else if (basicModElement instanceof BasicModTableOrViewColumn) {
            if (((BasicModTableOrViewColumn)obj).getParent() instanceof BasicView) {
                this.buildViewColumn((BasicModTableOrViewColumn)obj, source);
            } else {
                this.buildBasicElement(obj, source);
            }
        } else {
            this.buildBasicElement(obj, source);
        }
    }

    private final void buildViewColumn(BasicModTableOrViewColumn obj, DasObject source) {
        this.buildBasicElement(obj, source);
        obj.setNameSurrogate(!(source instanceof PsiColumn) || !(((PsiColumn)source).getNavigationElement() instanceof SqlColumnAliasDefinition));
    }

    protected void buildBasicElement(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (obj instanceof BasicModNamedElement) {
            this.buildNamedElement((BasicModNamedElement)obj, source);
        }
        if (obj instanceof BasicModArrangedElement) {
            this.buildArranged((BasicModArrangedElement)obj, source);
        }
        if (obj instanceof BasicModTypedElement) {
            this.buildTyped((BasicModTypedElement)obj, source);
        }
        if (obj instanceof BasicModColumniation) {
            this.buildColumniation((BasicModColumniation)obj, source);
        }
    }

    protected void buildView(@NotNull BasicModView obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        this.buildViewSource(obj, source);
    }

    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        ((BasicModModel)obj.getModel()).writeSources(new Runnable(this, obj, source){
            final /* synthetic */ SqlObjectBuilderImpl this$0;
            final /* synthetic */ BasicModView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                this.$obj.setSourceText(this.this$0.getViewQuery(this.$source, CompositeText.Kind.ORIGINAL_TEXT));
            }
            {
                this.this$0 = sqlObjectBuilderImpl;
                this.$obj = basicModView;
                this.$source = dasObject;
            }
        });
    }

    @Nullable
    protected final SimpleCompositeText getViewQuery(@NotNull DasObject source, @NotNull CompositeText.Kind kind) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        DasObject dasObject = source;
        if (!(dasObject instanceof SqlCreateViewStatement)) {
            dasObject = null;
        }
        return (object = (SqlCreateViewStatement)dasObject) != null && (object = object.getQueryExpression()) != null && (object = object.getText()) != null ? this.asComposite((String)object, kind) : null;
    }

    protected void buildForeignKey(@NotNull BasicModForeignKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setDeferrable(this.buildFkIsDeferrable(source));
        obj.setInitiallyDeferred(this.buildFkIsDeferred(source));
        obj.setOnDelete(this.buildFkOnDelete(source));
        obj.setOnUpdate(this.buildFkOnUpdate(source));
        obj.setRefColNames(this.buildFkRefColumns(source));
        obj.setRefTableName(this.buildFkRefTableName(source));
        obj.setRefSchemaName(this.buildFkRefSchemaName(source));
    }

    private final String buildFkRefSchemaName(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlForeignKeyDefinitionImpl) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlForeignKeyDefinitionImpl)source).getRefTableReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            string = this.buildNameFromRef((SqlReferenceExpression)object);
        } else {
            string = dasObject instanceof DasForeignKey ? StringUtil.nullize((String)((DasForeignKey)source).getRefTableSchema(), (boolean)true) : null;
        }
        return string;
    }

    private final String buildFkRefTableName(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof SqlForeignKeyDefinitionImpl ? this.buildNameFromRef(((SqlForeignKeyDefinitionImpl)source).getRefTableReference()) : (dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getRefTableName() : null);
    }

    private final List<String> buildFkRefColumns(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasForeignKey) {
            MultiRef multiRef = ((DasForeignKey)source).getRefColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.refColumns");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String buildNameFromRef(SqlReferenceExpression source) {
        if (source == null) {
            return null;
        }
        String string = this.buildNameFromPsiElement(source.resolve());
        if (string == null) {
            string = source.getName();
        }
        return string;
    }

    private final String buildNameFromPsiElement(PsiElement source) {
        PsiElement psiElement = source;
        return psiElement instanceof DasObject ? ((DasObject)source).getName() : (psiElement instanceof SqlNameElement ? ((SqlNameElement)source).getName() : null);
    }

    @NotNull
    protected final List<String> collectNames(@NotNull MultiRef<? extends DasObject> ref) {
        Intrinsics.checkParameterIsNotNull(ref, (String)"ref");
        ArrayList arrayList = ContainerUtil.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayList<String>()");
        ArrayList res2 = arrayList;
        MultiRef.It it = ref.iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            DasObject obj = (DasObject)it.resolve();
            Object object = obj;
            if (object == null || (object = object.getName()) == null) {
                object = name;
            }
            res2.add(object);
        }
        return res2;
    }

    private final CascadeRule buildFkOnDelete(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? DbImplUtil.asCascadeRule(((DasForeignKey)source).getDeleteRule()) : CascadeRule.no_action;
    }

    private final CascadeRule buildFkOnUpdate(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? DbImplUtil.asCascadeRule(((DasForeignKey)source).getUpdateRule()) : CascadeRule.no_action;
    }

    private final boolean buildFkIsDeferred(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getDeferrability() == DasForeignKey.Deferrability.INITIALLY_DEFERRED : false;
    }

    private final boolean buildFkIsDeferrable(DasObject source) {
        DasForeignKey.Deferrability deferrability;
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? (deferrability = ((DasForeignKey)source).getDeferrability()) != null && deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE : false;
    }

    protected void buildRoutine(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setRoutineKind(this.buildRoutineKind(source));
        if (obj instanceof BasicModSourceAware) {
            this.buildRoutineSources((BasicModSourceAware)((Object)obj), source);
        }
    }

    protected void buildRoutineSources(@NotNull BasicModSourceAware obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        ((BasicModModel)obj.getModel()).writeSources(new Runnable(this, obj, source){
            final /* synthetic */ SqlObjectBuilderImpl this$0;
            final /* synthetic */ BasicModSourceAware $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlElement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlElement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = sqlObjectBuilderImpl;
                this.$obj = basicModSourceAware;
                this.$source = dasObject;
            }
        });
    }

    private final DasRoutine.Kind buildRoutineKind(DasObject source) {
        DasObject dasObject = source;
        DasRoutine.Kind kind = dasObject instanceof DasRoutine ? ((DasRoutine)source).getRoutineKind() : DasRoutine.Kind.NONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, (String)"when (source) {\n    is D\u2026 DasRoutine.Kind.NONE\n  }");
        return kind;
    }

    protected void buildCheck(@NotNull BasicModCheck obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPredicate(this.buildCheckPredicate(source));
    }

    private final String buildCheckPredicate(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlConstraintDefinition) {
            SqlExpression sqlExpression = (SqlExpression)((SqlConstraintDefinition)source).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            string = sqlExpression != null ? sqlExpression.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setEvents(this.buildTriggerEvents(source));
        obj.setTurn(this.buildTriggerTurn(source));
        obj.setCondition(this.buildTriggerCondition(source));
    }

    private final Set<TrigEvent> buildTriggerEvents(DasObject source) {
        DasObject dasObject = source;
        Set set = dasObject instanceof DasTrigger ? ((DasTrigger)source).getEvents() : SetsKt.emptySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"when (source) {\n    is D\u2026   else -> emptySet()\n  }");
        return set;
    }

    private final TrigTurn buildTriggerTurn(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getTurn() : null;
    }

    private final String buildTriggerCondition(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getCondition() : null;
    }

    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setUnique(this.buildIndexUnique(source));
        obj.setReverseColNames(this.buildIndexReverseColumns(source));
    }

    private final boolean buildIndexUnique(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasIndex ? ((DasIndex)source).isUnique() : false;
    }

    private final Set<String> buildIndexReverseColumns(DasObject source) {
        Set set;
        DasObject dasObject = source;
        if (dasObject instanceof DasIndex) {
            DasTypedObject it;
            Iterable $receiver$iv$iv;
            Iterable iterable = ((DasIndex)source).getColumnsRef().resolveObjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"source.columnsRef.resolveObjects()");
            Iterable $receiver$iv = iterable;
            Iterable iterable2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)element$iv$iv;
                if (!(((DasIndex)source).getColumnSorting(it) == DasIndex.Sorting.DESCENDING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                DasTypedObject dasTypedObject = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dasTypedObject, (String)"it");
                String string = dasTypedObject.getName();
                collection.add(string);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPrimary(this.buildKeyIsPrimary(source));
    }

    private final boolean buildKeyIsPrimary(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTableKey ? ((DasTableKey)source).isPrimary() : false;
    }

    protected void buildArgument(@NotNull BasicModArgument obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setArgumentDirection(this.buildArgumentDir(source));
    }

    private final DasArgument.Direction buildArgumentDir(DasObject source) {
        DasObject dasObject = source;
        DasArgument.Direction direction = dasObject instanceof DasArgument ? ((DasArgument)source).getArgumentDirection() : DasArgument.Direction.IN;
        Intrinsics.checkExpressionValueIsNotNull((Object)direction, (String)"when (source) {\n    is D\u2026Argument.Direction.IN\n  }");
        return direction;
    }

    protected void buildColumniation(@NotNull BasicModColumniation obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setColNames(this.buildColumniationRefs(source));
    }

    private final List<String> buildColumniationRefs(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasConstraint) {
            MultiRef multiRef = ((DasConstraint)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else if (dasObject instanceof DasIndex) {
            MultiRef multiRef = ((DasIndex)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    protected void buildArranged(@NotNull BasicModArrangedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DasObject dasObject = source;
        if (!(dasObject instanceof DasPositioned)) {
            dasObject = null;
        }
        DasPositioned dasPositioned = (DasPositioned)dasObject;
        obj.setPosition(dasPositioned != null ? dasPositioned.getPosition() : (short)0);
    }

    private final short buildArrangedPos(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasPositioned ? ((DasPositioned)source).getPosition() : (short)0;
    }

    protected void buildTyped(@NotNull BasicModTypedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildTypedType(obj, source);
        obj.setDefaultExpression(this.buildTypedDef(source));
        obj.setNotNull(this.buildTypedNotNull(source));
    }

    protected void buildTypedType(@NotNull BasicModTypedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setDataType(this.extractType(source));
    }

    @NotNull
    protected final DataType extractType(@NotNull DasObject source) {
        DataType dataType;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DasObject dasObject = source;
        if (dasObject instanceof DasTypedObject) {
            DataType dataType2 = ((DasTypedObject)source).getDataType();
            dataType = dataType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"source.dataType");
        } else {
            DataType dataType3 = DataType.UNKNOWN;
            dataType = dataType3;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"DataType.UNKNOWN");
        }
        return dataType;
    }

    private final String buildTypedDef(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDefault() : null;
    }

    private final boolean buildTypedNotNull(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).isNotNull() : false;
    }

    protected void buildNamedElement(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.assignName(obj, source);
        obj.setComment(source.getComment());
        obj.setNameQuoted(DbSqlUtil.isQuoted(source));
        obj.setNameScripted(DbSqlUtil.isSqlObject(source));
    }

    protected void assignName(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setName(source.getName());
    }

    protected void buildNamespace(@NotNull BasicModNamespace obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        if (obj instanceof BasicModMateNamespace) {
            ((BasicModMateNamespace)obj).setVisible(true);
        }
    }

    protected final void forEachChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Unit> action) {
        PsiElement first$iv;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement psiElement = el;
        for (PsiElement tmp$iv = first$iv = (v484672) != null ? (v484672).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            action.invoke((Object)tmp$iv);
        }
    }

    protected final void forEachSibling(@Nullable PsiElement first, @NotNull Function1<? super PsiElement, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = first; tmp != null; tmp = tmp.getNextSibling()) {
            action.invoke((Object)tmp);
        }
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement parent2, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv$iv;
            SqlObjectBuilderImpl this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv = this;
            PsiElement psiElement2 = parent2;
            for (PsiElement tmp$iv$iv = element$iv$iv = (v484699) != null ? (v484699).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)type)) continue;
                psiElement = tmp$iv$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    private final <T> T findChild(PsiElement el) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            for (PsiElement tmp$iv = element$iv = (v484718) != null ? (v484718).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(it instanceof Object)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        return (T)psiElement;
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Boolean> action) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv;
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            for (PsiElement tmp$iv = element$iv = (v484742) != null ? (v484742).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                if (!((Boolean)action.invoke((Object)tmp$iv)).booleanValue()) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element2, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl this_$iv = this;
            for (PsiElement tmp$iv = element2; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)type)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element2, @NotNull Function1<? super PsiElement, Boolean> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = element2; tmp != null; tmp = tmp.getNextSibling()) {
            if (!((Boolean)action.invoke((Object)tmp)).booleanValue()) continue;
            return tmp;
        }
        return null;
    }

    @Nullable
    protected final String findString(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        return sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
    }

    @Nullable
    protected final Integer findInt(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    @Nullable
    protected final String extractName(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement psiElement = $receiver;
        return psiElement instanceof SqlReferenceExpressionImpl ? ((SqlReferenceExpressionImpl)$receiver).getName() : (psiElement instanceof SqlStringLiteralExpressionImpl ? ((SqlStringLiteralExpressionImpl)$receiver).getValue() : (this.getElementType($receiver) instanceof SqlKeywordTokenType || Intrinsics.areEqual((Object)this.getElementType($receiver), (Object)SqlTokens.SQL_IDENT) ? $receiver.getText() : null));
    }

    @Nullable
    protected final IElementType getElementType(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = $receiver.getNode();
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @NotNull
    protected final SimpleCompositeText asComposite(@NotNull String $receiver, @NotNull CompositeText.Kind kind) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        return new SimpleCompositeText($receiver, kind);
    }

    @NotNull
    public static /* synthetic */ SimpleCompositeText asComposite$default(SqlObjectBuilderImpl sqlObjectBuilderImpl, String string, CompositeText.Kind kind, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asComposite");
        }
        if ((n & 1) != 0) {
            kind = CompositeText.Kind.ORIGINAL_TEXT;
        }
        return sqlObjectBuilderImpl.asComposite(string, kind);
    }

    public static final /* synthetic */ void access$forEachSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement first, @NotNull Function1 action) {
        $this.forEachSibling(first, (Function1<? super PsiElement, Unit>)action);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement element2, @NotNull Function1 action) {
        return $this.findSibling(element2, (Function1<? super PsiElement, Boolean>)action);
    }
}

