/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.PhpInterpreterConfigurationForm;
import com.jetbrains.php.config.PhpInterpreterFormProvider;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBySdkConfig;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolByInterpreterConfigurableForm<C extends QualityToolConfiguration>
extends QualityToolConfigurableForm<C> {
    protected PhpInterpreterConfigurationForm myInterpreterConfigurationForm;
    private final QualityToolConfigurableForm<C> myDelegate;
    private final PhpSdkAdditionalData myRemoteSdkAdditionalData;

    public QualityToolByInterpreterConfigurableForm(@NotNull Project project, @NotNull C settings, @NotNull QualityToolConfigurableForm<C> delegate) {
        if (project == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(2);
        }
        super(project, settings, delegate.getToolName(), delegate.getToolLauncherName());
        this.myDelegate = delegate;
        this.myRemoteSdkAdditionalData = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterDataById(settings.getInterpreterId());
        this.addBrowseFolderListener(this.myProject, this.myToolPathField);
        assert (settings instanceof PhpSdkDependentConfiguration);
        PhpTestFrameworkBySdkConfig config = new PhpTestFrameworkBySdkConfig(project, (PhpSdkDependentConfiguration)settings);
        this.myInterpreterConfigurationForm = PhpInterpreterFormProvider.createForm((Project)project, (PhpInterpreterBasedConfig)config);
    }

    protected void addBrowseFolderListener(@NotNull Project project, @NotNull TextFieldWithBrowseButton textField) {
        if (project == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(3);
        }
        if (textField == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(4);
        }
        if (this.myRemoteSdkAdditionalData instanceof PhpRemoteSdkAdditionalData) {
            String title = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.remote.path.title", new Object[0]);
            PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)this.myRemoteSdkAdditionalData;
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            assert (manager != null);
            try {
                textField.addActionListener(manager.createRemoteBrowserAction(project, (PhpSdkAdditionalData)data, title, textField.getTextField(), false));
            }
            catch (PhpInvalidSdkTypeException e) {
                textField.getButton().setVisible(false);
            }
        }
    }

    @NotNull
    public JComponent createComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel interpreterPanel = new JPanel(new BorderLayout());
        interpreterPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10));
        String interpreterId = this.getConfiguration().getInterpreterId();
        this.myInterpreterConfigurationForm.setInterpreterEditable(false);
        this.myInterpreterConfigurationForm.reset();
        interpreterPanel.add((Component)this.myInterpreterConfigurationForm.getMainComponent(), "Center");
        panel.add((Component)interpreterPanel, "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)10, (int)0, (int)0));
        JComponent mainComponent = super.createComponent();
        assert (mainComponent != null);
        mainPanel.add((Component)mainComponent, "Center");
        panel.add((Component)mainPanel, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void disposeUIResources() {
        if (this.myInterpreterConfigurationForm != null) {
            Disposer.dispose((Disposable)this.myInterpreterConfigurationForm);
        }
    }

    @NotNull
    public Pair<Boolean, String> validateMessage(String message) {
        Pair pair = this.myDelegate.validateMessage(message);
        if (pair == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(6);
        }
        return pair;
    }

    public boolean isValidToolFile(VirtualFile file) {
        return this.myDelegate.isValidToolFile(file);
    }

    @NotNull
    public String getId() {
        String string = this.myDelegate.getId();
        if (string == null) {
            QualityToolByInterpreterConfigurableForm.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return this.myDelegate.getDisplayName();
    }

    @Nullable
    public String getHelpTopic() {
        return this.myDelegate.getHelpTopic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/tools/quality/QualityToolByInterpreterConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/tools/quality/QualityToolByInterpreterConfigurableForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

