/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassConstructorInsertHandler
extends PhpFunctionInsertHandler {
    private static final PhpClassConstructorInsertHandler instance = new PhpClassConstructorInsertHandler();

    public static PhpClassConstructorInsertHandler getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected Function getFunction(Editor editor, PhpNamedElement element) {
        PhpReference reference;
        PhpClass phpClass = null;
        if (element instanceof PhpClass) {
            phpClass = (PhpClass)element;
        } else if (element instanceof PhpUse && (reference = ((PhpUse)element).getTargetReference()) != null) {
            phpClass = StreamEx.of((Collection)reference.resolveGlobal(false)).select(PhpClass.class).findAny().orElse(null);
        }
        if (phpClass != null) {
            Method ownConstructor = phpClass.getOwnConstructor();
            return ownConstructor != null ? ownConstructor : phpClass.getConstructor();
        }
        return null;
    }

    @Override
    protected boolean shouldInsertParens(@NotNull PsiFile file, @Nullable Function function) {
        if (file == null) {
            PhpClassConstructorInsertHandler.$$$reportNull$$$0(0);
        }
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        return settings.PLACE_PARENS_FOR_CONSTRUCTOR != 2 || function != null && !ArrayUtil.isEmpty((Object[])function.getParameters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/completion/insert/PhpClassConstructorInsertHandler", "shouldInsertParens"));
    }
}

