/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerConfigurationDialog;
import com.jetbrains.php.composer.ComposerPhpInterpretersCombo;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerSynchronizationInitListener;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ComposerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ComposerDataService
implements PersistentStateComponent<ComposerState>,
ComposerRunningData {
    private final EventDispatcher<ComposerConfigListener> myEventDispatcher = EventDispatcher.create(ComposerConfigListener.class);
    private final EventDispatcher<ComposerSynchronizationInitListener> mySyncInitEventDispatcher = EventDispatcher.create(ComposerSynchronizationInitListener.class);
    private final Project myProject;
    @NotNull
    private ExecutionData myExecutionData = new ExecutionData();
    private String myConfigPath;
    private boolean myUpdateLibrary = true;
    private String myAddDependencyCommandLineOptions;
    private boolean myDoNotAskAgain;
    private SynchronizationState mySynchronizationState = SynchronizationState.NOT_INITIALIZED;
    private boolean myShouldDownloadPhar = false;
    private final AtomicBoolean myIsDownloading = new AtomicBoolean(false);

    public static ComposerDataService getInstance(Project project) {
        return (ComposerDataService)ServiceManager.getService((Project)project, ComposerDataService.class);
    }

    public ComposerDataService(Project project) {
        this.myProject = project;
    }

    @NotNull
    public ExecutionData getComposerExecutionData() {
        ExecutionData executionData = this.myExecutionData;
        if (executionData == null) {
            ComposerDataService.$$$reportNull$$$0(0);
        }
        return executionData;
    }

    public void setExecutionData(@NotNull ExecutionData executionData) {
        if (executionData == null) {
            ComposerDataService.$$$reportNull$$$0(1);
        }
        this.myExecutionData = executionData;
    }

    public static ExecutionData constructExecutionData(boolean useExecutable, @Nullable String executablePath, @Nullable String interpreterId, @Nullable String pharPath) {
        if (useExecutable) {
            return new ExecutionData(executablePath);
        }
        return new ExecutionData(interpreterId, pharPath);
    }

    public String getConfigPath() {
        return this.myConfigPath;
    }

    @Deprecated
    @Nullable
    public String getAddDependencyCommandLineOptions() {
        return this.myAddDependencyCommandLineOptions;
    }

    @Deprecated
    public void setAddDependencyCommandLineOptions(@Nullable String addDependencyCommandLineOptions) {
        this.myAddDependencyCommandLineOptions = addDependencyCommandLineOptions;
    }

    public void setConfigPathAndLibraryUpdateStatus(String configPath, boolean updateLibrary) {
        String oldPath = this.myConfigPath;
        this.myConfigPath = configPath;
        boolean oldStatus = this.myUpdateLibrary;
        this.myUpdateLibrary = updateLibrary;
        if (!StringUtil.equals((CharSequence)oldPath, (CharSequence)this.myConfigPath) || oldStatus != this.myUpdateLibrary) {
            ((ComposerConfigListener)this.myEventDispatcher.getMulticaster()).configPathOrLibraryStatusChanged(oldStatus, this.myUpdateLibrary);
        }
    }

    public boolean isUpdateLibrary() {
        return this.myUpdateLibrary;
    }

    @NotNull
    public SynchronizationState getSynchronizationState() {
        SynchronizationState synchronizationState = this.mySynchronizationState;
        if (synchronizationState == null) {
            ComposerDataService.$$$reportNull$$$0(2);
        }
        return synchronizationState;
    }

    public void setSynchronizationState(@NotNull SynchronizationState synchronizationState) {
        if (synchronizationState == null) {
            ComposerDataService.$$$reportNull$$$0(3);
        }
        SynchronizationState oldState = this.mySynchronizationState;
        this.mySynchronizationState = synchronizationState;
        if (oldState != SynchronizationState.SYNCHRONIZE && this.mySynchronizationState == SynchronizationState.SYNCHRONIZE) {
            ((ComposerSynchronizationInitListener)this.mySyncInitEventDispatcher.getMulticaster()).syncInitialized();
        }
    }

    public void addConfigListener(ComposerConfigListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void addSynchronizationInitListener(ComposerSynchronizationInitListener listener) {
        this.mySyncInitEventDispatcher.addListener((EventListener)listener);
    }

    protected boolean isExecutionWellConfigured(boolean quick) {
        if (this.myExecutionData.useExecutable()) {
            String path = this.myExecutionData.executablePath;
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return false;
            }
            if (!path.contains("\\") && !path.contains("/")) {
                return true;
            }
            return ComposerDataService.isWellConfigured(path);
        }
        if (!ComposerDataService.isWellConfigured(this.myExecutionData.pharPath)) {
            return false;
        }
        if (quick) {
            return true;
        }
        String phpPath = ComposerPhpInterpretersCombo.getPhpPath(this.myProject, this.myExecutionData.interpreterId);
        return !phpPath.isEmpty();
    }

    public boolean isConfigWellConfigured() {
        return ComposerDataService.isWellConfigured(this.myConfigPath);
    }

    private static boolean isWellConfigured(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public boolean syncLanguageLevel() {
        if (!this.isConfigWellConfigured()) {
            return false;
        }
        VirtualFile composerConfig = VfsUtil.findFileByIoFile((File)new File(this.myConfigPath), (boolean)true);
        return this.mySynchronizationState.equals((Object)SynchronizationState.SYNCHRONIZE) && composerConfig != null && ComposerConfigUtils.requiresPhp(composerConfig);
    }

    @Override
    public List<String> getComposerCommandBeginning() {
        return this.myExecutionData.getComposerCommandBeginning(this.myProject);
    }

    @Nullable
    public ComposerState getState() {
        return new ComposerState(this.myExecutionData, this.myConfigPath, this.myUpdateLibrary, this.myAddDependencyCommandLineOptions, this.myDoNotAskAgain, this.mySynchronizationState);
    }

    public void loadState(@NotNull ComposerState state) {
        if (state == null) {
            ComposerDataService.$$$reportNull$$$0(4);
        }
        this.myConfigPath = state.getConfigPath();
        String executablePath = state.getExecutablePath();
        if (state.getExecutionDataType() == ExecutionDataType.EXECUTABLE) {
            this.myExecutionData = new ExecutionData(executablePath);
        } else {
            String interpreterId = state.getInterpreterId();
            if (interpreterId == null) {
                interpreterId = ComposerDataService.guessOrCreateInterpreterId(state.getPhpPath(), this.myProject);
            }
            this.myExecutionData = new ExecutionData(interpreterId, StringUtil.notNullize((String)state.getPath()));
        }
        this.myUpdateLibrary = state.getUpdatePackages();
        this.mySynchronizationState = state.getSynchronizationState();
        this.myAddDependencyCommandLineOptions = state.getAddDependencyCommandLineOptions();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
    }

    @Nullable
    private static String guessOrCreateInterpreterId(String phpPath, @NotNull Project project) {
        if (project == null) {
            ComposerDataService.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)phpPath)) {
            return null;
        }
        HashSet<String> interpreterNames = new HashSet<String>();
        PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
        List<PhpInterpreter> interpreters = interpretersManager.getInterpreters();
        for (PhpInterpreter interpreter : interpreters) {
            if (interpreter.isRemote()) continue;
            interpreterNames.add(interpreter.getName());
            String executable = interpreter.getPathToPhpExecutable();
            if (!FileUtil.pathsEqual((String)phpPath, (String)executable)) continue;
            return interpreter.getId();
        }
        String baseName = PhpBundle.message("framework.composer.default.composer.interpreter.name", new Object[0]);
        int index = 0;
        String name = baseName;
        while (interpreterNames.contains(name)) {
            name = baseName + " (" + ++index + ")";
        }
        PhpInterpreter interpreter = new PhpInterpreter();
        interpreter.setIsProjectLevel(true);
        interpreter.setHomePath(FileUtil.toSystemDependentName((String)phpPath));
        interpreter.setName(name);
        interpreters.add(interpreter);
        interpretersManager.setInterpreters(interpreters);
        return interpreter.getId();
    }

    public boolean askForValidConfigurationIfNeeded() {
        if (this.isExecutionWellConfigured(false)) {
            return true;
        }
        boolean result = new ComposerConfigurationDialog(this.myProject, this, false, true).showAndGet();
        return result && this.isExecutionWellConfigured(false);
    }

    public void setDoNotAskAgain(boolean doNotAskAgain) {
        this.myDoNotAskAgain = doNotAskAgain;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    public boolean shouldDownload() {
        return this.myShouldDownloadPhar;
    }

    public void setShouldDownloadPhar(boolean shouldDownloadPhar) {
        if (!shouldDownloadPhar) {
            this.myShouldDownloadPhar = false;
            this.myIsDownloading.set(false);
            return;
        }
        if (this.myShouldDownloadPhar) {
            return;
        }
        this.myShouldDownloadPhar = true;
        if (this.myIsDownloading.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myIsDownloading.get()) {
                    return;
                }
                VirtualFile file = ComposerUtils.downloadPhar(this.myProject, null, this.myProject.getBaseDir().getPath());
                if (file != null) {
                    ExecutionData initialData = this.getComposerExecutionData();
                    initialData = ComposerDataService.constructExecutionData(initialData.useExecutable(), initialData.executablePath, initialData.interpreterId, file.getPath());
                    this.setExecutionData(initialData);
                }
                this.myIsDownloading.set(false);
                this.myShouldDownloadPhar = false;
            }, ModalityState.NON_MODAL);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synchronizationState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposerExecutionData";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerDataService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizationState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExecutionData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSynchronizationState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "guessOrCreateInterpreterId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExecutionData {
        @NotNull
        private final ExecutionDataType type;
        @NotNull
        public final String pharPath;
        @Nullable
        public final String interpreterId;
        @NotNull
        public final String executablePath;

        private ExecutionData(@Nullable String interpreterId, @Nullable String pharPath) {
            this.interpreterId = interpreterId;
            this.pharPath = StringUtil.notNullize((String)pharPath);
            this.executablePath = "";
            this.type = ExecutionDataType.PHAR;
        }

        private ExecutionData(@Nullable String executablePath) {
            this.interpreterId = null;
            this.pharPath = "";
            this.executablePath = StringUtil.notNullize((String)executablePath);
            this.type = ExecutionDataType.EXECUTABLE;
        }

        private ExecutionData() {
            this("");
        }

        public boolean useExecutable() {
            return this.type == ExecutionDataType.EXECUTABLE;
        }

        @NotNull
        public List<String> getComposerCommandBeginning(@Nullable Project project) {
            if (this.useExecutable()) {
                List<String> list = Collections.singletonList(this.executablePath);
                if (list == null) {
                    ExecutionData.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<String> list = Arrays.asList(ComposerPhpInterpretersCombo.getPhpPath(project, this.interpreterId), this.pharPath);
            if (list == null) {
                ExecutionData.$$$reportNull$$$0(1);
            }
            return list;
        }

        public boolean isDefault() {
            return this.equals(new ExecutionData());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionData data = (ExecutionData)o;
            if (this.type != data.type) {
                return false;
            }
            if (!this.pharPath.equals(data.pharPath)) {
                return false;
            }
            if (this.interpreterId != null ? !this.interpreterId.equals(data.interpreterId) : data.interpreterId != null) {
                return false;
            }
            return this.executablePath.equals(data.executablePath);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.pharPath.hashCode();
            result = 31 * result + (this.interpreterId != null ? this.interpreterId.hashCode() : 0);
            result = 31 * result + this.executablePath.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerDataService$ExecutionData", "getComposerCommandBeginning"));
        }
    }

    public static enum SynchronizationState {
        NOT_INITIALIZED,
        SYNCHRONIZE,
        DONT_SYNCHRONIZE;

    }

    @Tag(value="composer")
    public static class ComposerState {
        private String myPath;
        private String myConfigPath;
        private String myPhpPath;
        private String myInterpreterId;
        private String myExecutablePath;
        private boolean myUpdatePackages;
        private SynchronizationState mySynchronizationState;
        private String myAddDependencyCommandLineOptions;
        private boolean myDoNotAskAgain;
        private ExecutionDataType myExecutionDataType;

        public ComposerState(ExecutionData data, String configPath, boolean updatePackages, String options, boolean doNotAskAgain, @NotNull SynchronizationState synchronizationState) {
            if (synchronizationState == null) {
                ComposerState.$$$reportNull$$$0(0);
            }
            this.myPath = data.pharPath;
            this.myConfigPath = configPath;
            this.myInterpreterId = data.interpreterId;
            this.myExecutablePath = data.executablePath;
            this.myExecutionDataType = data.type;
            this.myUpdatePackages = updatePackages;
            this.mySynchronizationState = synchronizationState;
            this.myAddDependencyCommandLineOptions = options;
            this.myDoNotAskAgain = doNotAskAgain;
        }

        public ComposerState() {
            this(new ExecutionData(), null, true, null, false, SynchronizationState.NOT_INITIALIZED);
        }

        @Tag(value="pharPath")
        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        @Tag(value="pharConfigPath")
        public String getConfigPath() {
            return this.myConfigPath;
        }

        public void setConfigPath(String configPath) {
            this.myConfigPath = configPath;
        }

        @Tag(value="phpPath")
        public String getPhpPath() {
            return this.myPhpPath;
        }

        public void setPhpPath(String phpPath) {
            this.myPhpPath = phpPath;
        }

        @Tag(value="executablePath")
        public String getExecutablePath() {
            return this.myExecutablePath;
        }

        public void setExecutablePath(String executablePath) {
            this.myExecutablePath = executablePath;
        }

        @Attribute(value="updatePackages")
        public boolean getUpdatePackages() {
            return this.myUpdatePackages;
        }

        public void setUpdatePackages(boolean updatePackages) {
            this.myUpdatePackages = updatePackages;
        }

        @Attribute(value="synchronizationState")
        public SynchronizationState getSynchronizationState() {
            return this.mySynchronizationState;
        }

        public void setSynchronizationState(@NotNull SynchronizationState synchronizationState) {
            if (synchronizationState == null) {
                ComposerState.$$$reportNull$$$0(1);
            }
            this.mySynchronizationState = synchronizationState;
        }

        @Attribute(value="addDependencyOptions")
        public String getAddDependencyCommandLineOptions() {
            return this.myAddDependencyCommandLineOptions;
        }

        public void setAddDependencyCommandLineOptions(String addDependencyCommandLineOptions) {
            this.myAddDependencyCommandLineOptions = addDependencyCommandLineOptions;
        }

        @Attribute(value="phpInterpreterId")
        public String getInterpreterId() {
            return this.myInterpreterId;
        }

        public void setInterpreterId(String interpreterId) {
            this.myInterpreterId = interpreterId;
        }

        @Attribute(value="doNotAsk")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="executionDataType")
        public ExecutionDataType getExecutionDataType() {
            return this.myExecutionDataType;
        }

        public void setExecutionDataType(ExecutionDataType executionDataType) {
            this.myExecutionDataType = executionDataType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "synchronizationState";
            objectArray2[1] = "com/jetbrains/php/composer/ComposerDataService$ComposerState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSynchronizationState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ExecutionDataType {
        EXECUTABLE,
        PHAR;

    }
}

