/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddCatchClauseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.surroundWith.PhpTryCatchSurrounder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddCatchClauseQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Companion", "intellij.php.impl"})
public final class PhpAddCatchClauseQuickFix
implements LocalQuickFix {
    @NotNull
    private static final PhpAddCatchClauseQuickFix INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return "Add 'catch' clause(s)";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement element = descriptor.getPsiElement();
        Try try_ = (Try)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)applyFix.tryStatement.1.INSTANCE));
        if (try_ == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)try_, (String)"PhpPsiUtil.getParentByCo\u2026 { it is Try }) ?: return");
        Try tryStatement2 = try_;
        Object t = PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)applyFix.thrownRangeHolder.1.INSTANCE));
        if (t == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"PhpPsiUtil.getParentByCo\u2026PhpThrow\n    }) ?: return");
        Object thrownRangeHolder2 = t;
        Set<PhpType> exceptionClasses = PhpUnhandledExceptionInspection.Companion.getExceptionClasses((PsiElement)thrownRangeHolder2);
        if (exceptionClasses.isEmpty()) {
            return;
        }
        List<PhpType> list = PhpTryCatchSurrounder.sortByHierarchy(new ArrayList(exceptionClasses), project);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"PhpTryCatchSurrounder.so\u2026ceptionClasses), project)");
        List<PhpType> sortedExceptionClasses = list;
        StringBuilder template = new StringBuilder("try{}");
        Iterator<PhpType> iterator = sortedExceptionClasses.iterator();
        while (iterator.hasNext()) {
            PhpType exception;
            PhpType phpType = exception = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)phpType, (String)"exception");
            Set set = phpType.getTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"exception.types");
            String fqn = (String)CollectionsKt.single((Iterable)set);
            template.append("catch(").append(fqn).append(" $e){}");
        }
        Statement statement = PhpPsiElementFactory.createStatement(project, template.toString());
        if (statement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Try");
        }
        Catch[] catchArray = ((Try)statement).getCatchClauses();
        Intrinsics.checkExpressionValueIsNotNull((Object)catchArray, (String)"(PhpPsiElementFactory.cr\u2026g()) as Try).catchClauses");
        Catch[] catches = catchArray;
        List insertedCatches = new ArrayList();
        Finally finallyBlock = tryStatement2.getFinallyBlock();
        for (Catch catch_ : catches) {
            PsiElement insertedCatch;
            PsiElement psiElement = insertedCatch = finallyBlock != null ? tryStatement2.addBefore((PsiElement)catch_, (PsiElement)finallyBlock) : tryStatement2.add((PsiElement)catch_);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Catch");
            }
            insertedCatches.add((Catch)psiElement);
        }
        PhpTryCatchSurrounder.importClassReferences(tryStatement2, insertedCatches);
        Collection collection = insertedCatches;
        if (!collection.isEmpty()) {
            Collection collection2 = ((Catch)CollectionsKt.first((List)insertedCatches)).getExceptionTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"insertedCatches.first().exceptionTypes");
            Object object = CollectionsKt.first((Iterable)collection2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"insertedCatches.first().exceptionTypes.first()");
            int n = ((ClassReference)object).getTextOffset();
            Editor editor = PsiUtilBase.findEditor((PsiElement)element);
            if (editor == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"PsiUtilBase.findEditor(element) ?: return");
            Editor editor2 = editor;
            editor2.getCaretModel().moveToOffset(n);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new PhpAddCatchClauseQuickFix();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddCatchClauseQuickFix$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddCatchClauseQuickFix;", "getINSTANCE", "()Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddCatchClauseQuickFix;", "intellij.php.impl"})
    public static final class Companion {
        @NotNull
        public final PhpAddCatchClauseQuickFix getINSTANCE() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

