/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFlipBinaryExpressionIntention
extends PsiElementBaseIntentionAction {
    private static final String FAMILY_NAME = PhpBundle.message("intention.flip.binary.expression.family.name", new Object[0]);

    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static BinaryExpression getBinaryExpression(@NotNull PsiElement element) {
        BinaryExpression binaryExpression;
        if (element == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(1);
        }
        if ((binaryExpression = (BinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, BinaryExpression.class)) != null && !PsiTreeUtil.hasErrorElements((PsiElement)binaryExpression)) {
            return binaryExpression;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(4);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        BinaryExpression binaryExpression = PhpFlipBinaryExpressionIntention.getBinaryExpression(element);
        if (binaryExpression != null) {
            PsiElement operation = binaryExpression.getOperation();
            assert (operation != null);
            String operationText = operation.getText();
            IElementType operator = operation.getNode().getElementType();
            if (PhpLangUtil.isCommutativeOperator(operator)) {
                if (PhpLangUtil.isShortCircuitOperator(operator)) {
                    this.setText(PhpBundle.message("intention.flip.binary.expression.text2", operationText));
                } else {
                    this.setText(PhpBundle.message("intention.flip.binary.expression.text1", operationText));
                }
            } else {
                this.setText(PhpBundle.message("intention.flip.binary.expression.text3", operationText));
            }
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(7);
        }
        BinaryExpression binaryExpression = PhpFlipBinaryExpressionIntention.getBinaryExpression(element);
        assert (binaryExpression != null);
        PsiElement leftOperand = binaryExpression.getLeftOperand();
        assert (leftOperand != null);
        PsiElement rightOperand = binaryExpression.getRightOperand();
        assert (rightOperand != null);
        BinaryExpression copyOfBinaryExpression = (BinaryExpression)binaryExpression.copy();
        leftOperand.replace(copyOfBinaryExpression.getRightOperand());
        rightOperand.replace(copyOfBinaryExpression.getLeftOperand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpFlipBinaryExpressionIntention";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpFlipBinaryExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

