/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;

public class ClassReference {
    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Namespace.parseReference(builder);
        if (builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.kwSTATIC)) {
            builder.advanceLexer();
            marker.done(PhpElementTypes.CLASS_REFERENCE);
            return PhpElementTypes.CLASS_REFERENCE;
        }
        marker.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseClassNameReference(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = ClassReference.parseDynamicClassNameReference(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            Namespace.parseReference(builder);
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER) || builder.compareAndEat(PhpTokenTypes.kwSTATIC)) {
                marker.done(PhpElementTypes.CLASS_REFERENCE);
                return PhpElementTypes.CLASS_REFERENCE;
            }
            marker.drop();
        } else {
            marker.done(PhpElementTypes.CLASS_REFERENCE);
            result = PhpElementTypes.CLASS_REFERENCE;
        }
        return result;
    }

    private static IElementType parseDynamicClassNameReference(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = Variable.parseBaseVariable(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            while (builder.compareAndEat(PhpTokenTypes.ARROW)) {
                marker.done(result);
                marker = marker.precede();
                result = Variable.parseObjectProperty(builder);
                if (result != PhpElementTypes.EMPTY_INPUT) continue;
                builder.error(PhpParserErrors.expected("object property"));
            }
        }
        if (result != PhpElementTypes.EMPTY_INPUT) {
            marker.done(result);
        } else {
            marker.drop();
        }
        return result;
    }
}

